package edu.unika.aifb.kaon.datalog.evaluation;

import edu.unika.aifb.kaon.datalog.program.*;

/**
 * Implements a lexicographical ordering of ground literals.
 */
public class LexicographicalGroundLiteralOrdering implements GroundLiteralOrdering {
    /** The query predicate (which is always maximal. Can be <code>null</code>. */
    protected Predicate m_queryPredicate;

    /**
     * Creates an instance of this class.
     *
     * @param queryPredicate                the predicate of the query (can be <code>null</code>)
     */
    public LexicographicalGroundLiteralOrdering(Predicate queryPredicate) {
        m_queryPredicate=queryPredicate;
    }
    /**
     * Compares two ground literals.
     *
     * @param predicate1                    the first predicate
     * @param predicate2                    the second predicate
     * @return                              -1 if the first predicate is smaller, 1 if it is bigger or 0 if they are the same
     */
    public int compareTo(Predicate predicate1,Predicate predicate2) {
        if (!predicate1.equals(predicate2)) {
            if (predicate1.equals(m_queryPredicate))
                return 1;
            if (predicate2.equals(m_queryPredicate))
                return -1;
            int result=predicate1.hashCode()-predicate2.hashCode();
            if (result==0)
                result=predicate1.getFullName().compareTo(predicate2.getFullName());
            return result;
        }
        else
            return 0;
    }
    /**
     * Compares two ground literals.
     *
     * @param predicate1                    the first predicate of the literal
     * @param tuple1                        the first tuple of the literal
     * @param predicate2                    the second predicate of the literal
     * @param tuple2                        the second tuple of the literal
     * @return                              -1 if the first literal is smaller, 1 if it is bigger or 0 if they are the same
     */
    public int compareTo(Predicate predicate1,Object[] tuple1,Predicate predicate2,Object[] tuple2) {
        int result=compareTo(predicate1,predicate2);
        if (result==0) {
            int length=tuple1.length;
            for (int i=0;i<length;i++) {
                String value1=tuple1[i].toString();
                String value2=tuple2[i].toString();
                result=value1.compareTo(value2);
                if (result!=0)
                    break;
            }
        }
        return result;
    }
    /**
     * Returns the same ordering, but with the supplied predicate as the maximum predicate.
     *
     * @param queryPredicate                the query predicate
     * @return                              the same ordering, but with the supplied predicate as the maximum
     */
    public GroundLiteralOrdering getOrderingForQueryPredicate(Predicate queryPredicate) {
        return new LexicographicalGroundLiteralOrdering(queryPredicate);
    }
}
