package edu.unika.aifb.kaon.datalog.evaluation;

/**
 * A filter for the tuples during join. Filters are typically used for residual conditions in jois.
 * Residual conditions are any conditions other than the equality of the join variables.
 */
public interface JoinTupleFilter {
    /**
     * Checks whether two tuples can be joined.
     *
     * @param tuple1                        the first tuple
     * @param tuple2                        the second tuple
     * @return                              <code>true</code> if tuples should be joined
     */
    boolean shouldJoin(Object[] tuple1,Object[] tuple2);
}
