package edu.unika.aifb.kaon.datalog.evaluation;

import edu.unika.aifb.kaon.datalog.program.*;

/**
 * Provides an ordering of ground literals and of literal predicates.
 */
public interface GroundLiteralOrdering {
    /**
     * Compares two predicates.
     *
     * @param predicate1                    the first predicate
     * @param predicate2                    the second predicate
     * @return                              -1 if the first predicate is smaller, 1 if it is bigger or 0 if they are the same
     */
    int compareTo(Predicate predicate1,Predicate predicate2);
    /**
     * Compares two ground literals.
     *
     * @param predicate1                    the first predicate of the literal
     * @param tuple1                        the first tuple of the literal
     * @param predicate2                    the second predicate of the literal
     * @param tuple2                        the second tuple of the literal
     * @return                              -1 if the first literal is smaller, 1 if it is bigger or 0 if they are the same
     */
    int compareTo(Predicate predicate1,Object[] tuple1,Predicate predicate2,Object[] tuple2);
    /**
     * Returns the same ordering, but with the supplied predicate as the maximum predicate.
     *
     * @param queryPredicate                the query predicate
     * @return                              the same ordering, but with the supplied predicate as the maximum
     */
    GroundLiteralOrdering getOrderingForQueryPredicate(Predicate queryPredicate);
}
