package edu.unika.aifb.kaon.datalog.evaluation;

import edu.unika.aifb.kaon.datalog.*;
import edu.unika.aifb.kaon.datalog.program.*;

/**
 * Represents an extensional database. There may be many implementations for differet sources.
 */
public interface ExtensionalDatabase {
    /**
     * Returns <code>true</code> if supplied predicate can be evaluated in this database.
     *
     * @param predicate                         the predicate
     * @return                                  <code>true</code> if supplied predicate can be evaluated in this database
     * @throws DatalogException                 thrown if there is an error
     */
    boolean canEvaluatePredicate(Predicate predicate) throws DatalogException;
    /**
     * Returns <code>true</code> if supplied predicate in this database contains disjunction information.
     *
     * @param predicate                         the predicate
     * @return                                  <code>true</code> if supplied predicate in this database contains disjunction information
     * @throws DatalogException                 thrown if there is an error (e.g. if the predicate can't be evaluated by this database)
     */
    boolean getContainsDisjunctionInfo(Predicate predicate) throws DatalogException;
    /**
     * Creates an operator that evaluates specified literals using the values from the operator passed in.
     *
     * @param literals                          the literals to be evaluated
     * @param bindingsOperator                  the operator producing the bindings
     * @param boundVariables                    the variables of the bindings
     * @param returnedVariables                 the variables that the operator should return
     * @return                                  the query operator evaluating specified literals
     * @throws DatalogException                 thrown if there is an error
     */
    QueryOperator createQueryOperator(Literal[] literals,QueryOperator bindingsOperator,Variable[] boundVariables,Variable[] returnedVariables) throws DatalogException;
    /**
     * Creates an operator that evaluatesspecified literals with no variables passed in.
     *
     * @param literals                          the literals to be evaluated
     * @param returnedVariables                 the variables that the operator should return
     * @return                                  the query operator evaluating specified literals
     * @throws DatalogException                 thrown if there is an error
     */
    QueryOperator createQueryOperator(Literal[] literals,Variable[] returnedVariables) throws DatalogException;
}
