package edu.unika.aifb.kaon.datalog.evaluation;

/**
 * Aa abstract base class for collections of tuples where the identity of the tuples is
 */
public abstract class AbstractTupleCollection {
    /** The indices determining the tuple key equality. */
    protected int[] m_keyEqualityIndices;

    /**
     * Creates an instance of this class.
     *
     * @param keyEqualityIndices            the indices determining the equality of tuples as keys
     */
    public AbstractTupleCollection(int[] keyEqualityIndices) {
        m_keyEqualityIndices=keyEqualityIndices;
    }
    /**
     * Returns the key hash-code of the tuple.
     *
     * @param tuple                         the tuple
     * @param equalityIndices               the indices determining the equality
     * @return                              the hash-code of the tuple
     */
    protected int tupleKeyHashCode(Object[] tuple,int[] equalityIndices) {
        int hashCode=0;
        for (int i=equalityIndices.length-1;i>=0;--i) {
            Object object=tuple[equalityIndices[i]];
            if (object!=null)
                hashCode=hashCode*7+object.hashCode();
        }
        return hashCode;
    }
    /**
     * Returns <code>true</code> if the tuples are equal. The tuples are assumed to belong to the same relation (this is not checked).
     *
     * @param tuple1                        the first tuple
     * @param equalityIndices1              the indices of the first tuple determining the equality
     * @param tuple2                        the second tuple
     * @param equalityIndices2              the indices of the second tuple determining the equality
     * @return                              <code>true</code> if the tuples are equal
     */
    protected boolean tuplesKeyEqual(Object[] tuple1,int[] equalityIndices1,Object[] tuple2,int[] equalityIndices2) {
        for (int i=equalityIndices1.length-1;i>=0;--i) {
            Object value1=tuple1[equalityIndices1[i]];
            Object value2=tuple2[equalityIndices2[i]];
            if (value1!=value2 && (value1==null || !value1.equals(value2)))
                return false;
        }
        return true;
    }
}
