package edu.unika.aifb.kaon.apiproxy.source;

/**
 * Combines an entity ID and a source URI of the model in which the relation has been defined.
 */
public class RelationEntityID extends EntityID {
    /** Serial version. */
    public static final long serialVersionUID=-4574556431964004703L;
    /** The ID of the model in which the relation was declared. */
    public int m_sourceOIModelID;

    /**
     * Creates an instance of this class.
     */
    public RelationEntityID() {
    }
    /**
     * Creates an instance of this class.
     *
     * @param uri                       the URI of the entity
     * @param version                   the version of the entity
     * @param sourceOIModelID           the ID of the OI-model in which the relation has been defined
     */
    public RelationEntityID(String uri,int version,int sourceOIModelID) {
        super(uri,version);
        m_sourceOIModelID=sourceOIModelID;
    }
}
