package edu.unika.aifb.kaon.apiproxy.source;

import java.io.Serializable;

/**
 * Combines the value of the property and the ID of the model where the relation was defined.
 */
public class PropertyValue implements Serializable {
    /** Serial version. */
    public static final long serialVersionUID=6286388341536151158L;
    /** The value of the property. */
    public String m_textValue;
    /** The ID of the model. */
    public int m_sourceOIModelID;

    /**
     * Creates an instance of this class.
     */
    public PropertyValue() {
    }
    /**
     * Creates an instance of this class.
     *
     * @param textValue                 the value of the property
     * @param sourceOIModelID           the ID of the model
     */
    public PropertyValue(String textValue,int sourceOIModelID) {
        m_textValue=textValue;
        m_sourceOIModelID=sourceOIModelID;
    }
    /**
     * Returns the hashcode of this object.
     *
     * @return                          hashcode
     */
    public int hashCode() {
        return m_textValue.hashCode();
    }
    /**
     * Checks whether two objects of this class are equal.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof PropertyValue))
            return false;
        PropertyValue thatPropertyValue=(PropertyValue)that;
        return m_textValue.equals(thatPropertyValue.m_textValue);
    }
}
