package edu.unika.aifb.kaon.apiproxy.source;

/**
 * Contains information about a property. This class is optimized for remote communication.
 * If some of the fields are <code>null</code>, this means that appropriate field hasn't been loaded.
 */
public class PropertyInfo extends EntityInfo {
    /** The array of superproperty IDs. */
    public RelationEntityID[] m_superPropertyIDs;
    /** The array of subproperty IDs. */
    public EntityID[] m_subPropertyIDs;
    /** The array of the property domain infos. */
    public DomainInfo[] m_domainInfos;
    /** The array of the range concept IDs. */
    public RelationEntityID[] m_rangeConceptIDs;
    /** The array of property instances - the first object is the source ID, and the second is the target ID or the value. */
    public Object[][] m_propertyInstances;
    /** Set to <code>true</code> if the property is symetric. */
    public boolean m_symmetric;
    /** Set to <code>true</code> if the property is transitive. */
    public boolean m_transitive;
    /** Set to <code>true</code> if the property is an attribute. */
    public boolean m_isAttribute;
    /** The ID of the inverse property. */
    public RelationEntityID m_inversePropertyID;

    /**
     * Creates an instance of this class.
     */
    public PropertyInfo() {
    }
    /**
     * Creates an instance of this class.
     *
     * @param uri                   the URI of the entity
     * @param version               the version of the entity
     */
    public PropertyInfo(String uri,int version) {
        super(uri,version);
    }
}