package edu.unika.aifb.kaon.apiproxy.source;

/**
 * Contains information about a instance. This class is optimized for remote communication.
 * If some of the fields are <code>null</code>, this means that appropriate field hasn't been loaded.
 */
public class InstanceInfo extends EntityInfo {
    /** The array of parent concepts IDs of an instance. */
    public RelationEntityID[] m_instanceParentConceptIDs;
    /**
     * The array of instance values. In each row the first element is denotes the property, whereas all
     * other elements are either EntityID of the instance or <code>String</code> objects.
     */
    public Object[][] m_propertyValuesFrom;
    /**
     * The array of instances pointing to this object. In each row the first element is denotes the property, whereas all
     * other elements are either EntityID of the instance or <code>String</code> objects.
     */
    public Object[][] m_propertyValuesTo;

    /**
     * Creates an instance of this class.
     */
    public InstanceInfo() {
    }
    /**
     * Creates an instance of this class.
     *
     * @param uri                   the URI of the entity
     * @param version               the version of the entity
     */
    public InstanceInfo(String uri,int version) {
        super(uri,version);
    }
}