package edu.unika.aifb.kaon.apiproxy.source;

import java.io.Serializable;

/**
 * Contains information about an entity. This class is optimized for remote communication.
 * If some of the fields are <code>null</code>, this means that appropriate field hasn't been loaded.
 */
public abstract class EntityInfo implements Serializable {
    /** The serial version. */
    public static final long serialVersionUID=6091156397777792563L;
    /** The ID of the entity. */
    public EntityID m_id;
    /** The ID of the model in which the entity was declared. */
    public int m_modelID;

    /**
     * Creates an instance of this class.
     */
    public EntityInfo() {
    }
    /**
     * Creates an instance of this class.
     *
     * @param uri                   the URI of the entity
     * @param version               the version of the entity
     */
    public EntityInfo(String uri,int version) {
        m_id=new EntityID(uri,version);
        m_modelID=-1;
    }
}