package edu.unika.aifb.kaon.apiproxy.source;

import java.io.Serializable;

/**
 * Combines an URI and a version number of an entity.
 */
public class EntityID implements Serializable {
    /** Serial version. */
    public static final long serialVersionUID=4044695965212846675L;
    /** The URI of an entity. */
    public String m_uri;
    /** The version number of an entity. */
    public int m_version;

    /**
     * Creates an instance of this class.
     */
    public EntityID() {
    }
    /**
     * Creates an instance of this class.
     *
     * @param uri                       the URI of the entity
     * @param version                   the version of the entity
     */
    public EntityID(String uri,int version) {
        m_uri=uri;
        m_version=version;
    }
    /**
     * Returns the hashcode of this object.
     *
     * @return                          hashcode
     */
    public int hashCode() {
        return m_uri.hashCode();
    }
    /**
     * Checks whether two objects of this class are equal.
     *
     * @param that                      the other object
     * @return                          <code>true</code> if objects are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof EntityID))
            return false;
        EntityID thatEntityID=(EntityID)that;
        return m_uri.equals(thatEntityID.m_uri) && m_version==thatEntityID.m_version;
    }
}
