package edu.unika.aifb.kaon.apiproxy.source;

import java.io.Serializable;

/**
 * Holds information about the domain of some property.
 */
public class DomainInfo implements Serializable {
    /** The ID of the concept that is the domain of the range. */
    public RelationEntityID m_conceptID;
    /** The minimum cardinality. */
    public int m_minimumCardinality;
    /** The maximum cardinality. */
    public int m_maximumCardinality;

    /**
     * Creates a instance of this class.
     */
    public DomainInfo() {
    }
    /**
     * Creates a instance of this class.
     *
     * @param conceptURI                the URI of the concept
     * @param conceptVersion            the version number of the concept
     * @param sourceOIModelID           the ID of the OI-model where this domain was declared
     * @param minimumCardinality        the minimum cardinality of the concept
     * @param maximumCardinality        the maximum cardinality of the concept
     */
    public DomainInfo(String conceptURI,int conceptVersion,int sourceOIModelID,int minimumCardinality,int maximumCardinality) {
        m_conceptID=new RelationEntityID(conceptURI,conceptVersion,sourceOIModelID);
        m_minimumCardinality=minimumCardinality;
        m_maximumCardinality=maximumCardinality;
    }
}
