package edu.unika.aifb.kaon.apiproxy.source;

/**
 * Contains information about a concept. This class is optimized for remote communication.
 * If some of the fields are <code>null</code>, this means that appropriate field hasn't been loaded.
 */
public class ConceptInfo extends EntityInfo {
    /** The array of superconcept IDs. */
    public RelationEntityID[] m_superConceptIDs;
    /** The array of subconcept IDs. */
    public EntityID[] m_subConceptIDs;
    /** The array of property IDs going from the concept. */
    public EntityID[] m_propertiesFromIDs;
    /** The array of property IDs going to the concept. */
    public EntityID[] m_propertiesToIDs;
    /** The array of the IDs of concept instances. */
    public EntityID[] m_instanceIDs;

    /**
     * Creates an instance of this class.
     */
    public ConceptInfo() {
    }
    /**
     * Creates an instance of this class.
     *
     * @param uri                   the URI of the entity
     * @param version               the version of the entity
     */
    public ConceptInfo(String uri,int version) {
        super(uri,version);
    }
}