package edu.unika.aifb.kaon.apiproxy;

import java.io.Serializable;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Implementation of an instance of a property.
 */
public class PropertyInstanceProxy implements PropertyInstance,Serializable {
    /** Property that this object is instance of. */
    protected PropertyProxy m_property;
    /** Source instance. */
    protected InstanceProxy m_sourceInstance;
    /** Target value (may be <code>Instance</code> or <code>String</code>. */
    protected Object m_targetValue;
    /** The source OI-model of this property instance. */
    protected OIModel m_sourceOIModel;

    /**
     * Creates an instance of this class.
     *
     * @param property                          property
     * @param sourceInstance                    source instance of this property instance
     * @param targetValue                       target value (<code>String</code> or an <code>Instnace</code>)
     */
    public PropertyInstanceProxy(PropertyProxy property,InstanceProxy sourceInstance,Object targetValue) {
        m_property=property;
        m_sourceInstance=sourceInstance;
        m_targetValue=targetValue;
    }
    /**
     * Returns the property.
     *
     * @return                                  property
     */
    public Property getProperty() {
        return m_property;
    }
    /**
     * Returns the instance that this relation points from.
     *
     * @return                                  source instance
     */
    public Instance getSourceInstance() {
        return m_sourceInstance;
    }
    /**
     * Returns the value of this relation instnace (may be <code>String</code> or <code>Instance</code>).
     *
     * @return                                  value of this relaiton instance (<code>String</code> or <code>Instnace</code>)
     */
    public Object getTargetValue() {
        return m_targetValue;
    }
    /**
     * Returns the OI-model of this object.
     *
     * @return                                  the OI-model of this object
     */
    public OIModel getOIModel() {
        return m_property.getOIModel();
    }
    /**
     * Checks whether this property instance is in the OI-model.
     *
     * @return                                  <code>true</code> if this property instance is in the OI-model.
     */
    public boolean isInOIModel() throws KAONException {
        synchronized (getLock()) {
            if (!m_sourceInstance.isInOIModel())
                return false;
            if (!m_property.isInOIModel())
                return false;
            if (m_targetValue instanceof Instance)
                if (!((Instance)m_targetValue).isInOIModel())
                    return false;
            return m_sourceInstance.getFromPropertyValues(m_property).contains(m_targetValue);
        }
    }
    /**
     * Returns <code>true</code> if this entity has been declared in the OI-model as returned
     * by <code>getOIModel()</code> call.
     *
     * @return                          <code>true</code> if this entity case declared in the OI-model as returned by <code>getOIModel()</code> call
     */
    public boolean isDeclaredLocally() throws KAONException {
        synchronized (getLock()) {
            return getSourceOIModel()==getOIModel();
        }
    }
    /**
     * Returns the source OI-model of this object.
     *
     * @return                                  the source OI-model of this object
     */
    public OIModel getSourceOIModel() throws KAONException {
        synchronized (getLock()) {
            if (m_sourceOIModel==null)
                m_sourceInstance.loadThisObject(OIModel.LOAD_INSTANCE_FROM_PROPERTY_VALUES);
            return m_sourceOIModel;
        }
    }
    /**
     * Sets the source OI-model of this object.
     *
     * @param sourceOIModel                     the source OI-model
     */
    void setSourceOIModel(OIModel sourceOIModel) {
        m_sourceOIModel=sourceOIModel;
    }
    /**
     * Returns the lock object for this entity.
     *
     * @return                              the lock object for the entity
     */
    protected Object getLock() {
        return m_property.m_oimodel.m_kaonConnection;
    }
}
