package edu.unika.aifb.kaon.apionrdf.test;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.LinkedList;
import java.util.Collections;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.apionrdf.*;

/**
 * Abstract class for all tests that sets up an in-memory RDF model.
 */
public abstract class SingleModelTest extends BaseTest {
    protected Model m_model;
    protected OIModel m_oimodel;

    public SingleModelTest(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        m_model=createModel();
        addModel(m_model,getDefaultModel());
        loadOIModel();
    }
    protected Model createModel() throws Exception {
        return RDFManager.createModel("file:///c:/temp/test.kaon",null);
    }
    protected void loadOIModel() throws Exception {
        KAONConnectionImpl connection=new KAONConnectionImpl();
        m_oimodel=connection.getOIModelForRDFModel(m_model);
    }
    protected void applyChanges(ChangeEvent[] events) throws Exception {
        List list=new LinkedList();
        for (int i=0;i<events.length;i++)
            list.add(events[i]);
        applyChanges(list);
    }
    protected void applyChanges(final List list) throws Exception {
        final boolean[] correct=new boolean[1];
        correct[0]=true;
        OIModelListener listener=new OIModelListener() {
            public void modelChanged(OIModel model,List changeEvents) {
                correct[0]=list.size()==changeEvents.size() && list.containsAll(changeEvents);
            }
            public void modelRefreshed(OIModel oimodel) {
            }
            public void modelDeleted(OIModel oimodel) {
            }
        };
        m_oimodel.addOIModelListener(listener);
        try {
            m_oimodel.applyChanges(list);
        }
        finally {
            m_oimodel.removeOIModelListener(listener);
        }
        assertTrue("Not all events were dispatched to listeners.",correct[0]);
    }
    protected void applyChange(ChangeEvent event) throws Exception {
        m_oimodel.applyChanges(Collections.singletonList(event));
    }
    protected void assertInModel(String subject,String predicate,String object,boolean isLiteral) throws Exception {
        assertInModel(m_model,subject,predicate,object,isLiteral);
    }
    protected void assertNotInModel(String subject,String predicate,String object,boolean isLiteral) throws Exception {
        assertNotInModel(m_model,subject,predicate,object,isLiteral);
    }
    protected abstract Model getDefaultModel();
    protected static void addModel(Model target,Model source) throws Exception {
        Iterator iterator=source.iterator();
        NodeFactory nodeFactory=target.getNodeFactory();
        while (iterator.hasNext()) {
            Statement statement=(Statement)iterator.next();
            Resource subject=nodeFactory.createResource(statement.subject().getURI());
            Resource predicate=nodeFactory.createResource(statement.predicate().getURI());
            RDFNode object=statement.object();
            if (object instanceof Resource)
                object=nodeFactory.createResource(((Resource)object).getURI());
            else
                object=nodeFactory.createLiteral(object.getLabel());
            target.add(nodeFactory.createStatement(subject,predicate,object));
        }
    }
}
