package edu.unika.aifb.kaon.apionrdf.test;

import java.util.Set;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

public class PropertyTest extends JaguarXMLTest {

    public PropertyTest(String name) {
        super(name);
    }
    public void testPropertyIdentity() throws Exception {
        assertTrue(m_runsOver==m_oimodel.getProperty("test:runs_over"));
    }
    public void testSubProperties() throws Exception {
        Set set=m_runsOver.getSubProperties();
        assertEquals(1,set.size());
        assertTrue(set.contains(m_BMWRunsOverCat));
    }
    public void testAllSubProperties() throws Exception {
        Set set=m_runsOver.getAllSubProperties();
        assertEquals(2,set.size());
        assertTrue(set.contains(m_BMWRunsOverCat));
        assertTrue(set.contains(m_BMWRunsOverJaguar));
    }
    public void testSuperProperties() throws Exception {
        Set set=m_BMWRunsOverJaguar.getSuperProperties();
        assertEquals(1,set.size());
        assertTrue(set.contains(m_BMWRunsOverCat));
    }
    public void testAllSuperProperties() throws Exception {
        Set set=m_BMWRunsOverJaguar.getAllSuperProperties();
        assertEquals(2,set.size());
        assertTrue(set.contains(m_BMWRunsOverCat));
        assertTrue(set.contains(m_runsOver));
    }
    public void testIsDirectSubProperty() throws Exception {
        assertTrue(m_BMWRunsOverCat.isDirectSubPropertyOf(m_runsOver));
    }
    public void testIsSubProperty() throws Exception {
        assertTrue(m_BMWRunsOverJaguar.isSubPropertyOf(m_runsOver));
        assertTrue(!m_BMWRunsOverJaguar.isDirectSubPropertyOf(m_runsOver));
    }
    public void testDomainConcepts() throws Exception {
        Set set=m_color.getDomainConcepts();
        assertEquals(2,set.size());
        assertTrue(set.contains(m_car));
        assertTrue(set.contains(m_cat));
    }
    public void testRangeConcepts() throws Exception {
        assertEquals(0,m_color.getRangeConcepts().size());
        assertTrue(m_color.isAttribute());
        assertTrue(m_runsOver.getRangeConcepts().contains(m_cat));
        assertTrue(!m_runsOver.isAttribute());
    }
    public void testNoDomain() throws Exception {
        assertTrue(m_noDomainNoRange.getDomainConcepts().isEmpty());
    }
    public void testNoRange() throws Exception {
        assertTrue(m_noDomainNoRange.getRangeConcepts().isEmpty());
        assertTrue(!m_noDomainNoRange.isAttribute());
    }
    public void testPropertyInstances1() throws Exception {
        assertSetEquals(m_runsOver.getPropertyInstances(),new Object[] {
            m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Garfield),
            m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Silvester),
            m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar2,m_Silvester),
        });
    }
    public void testPropertyInstances2() throws Exception {
        assertSetEquals(m_wheelsNo.getPropertyInstances(),new Object[] {
            m_oimodel.getPropertyInstance(m_wheelsNo,m_jaguarCar1,"6"),
            m_oimodel.getPropertyInstance(m_wheelsNo,m_jaguarCar2,"3"),
        });
    }
    public void testInverseProperty() throws Exception {
        assertSame(m_runsOver.getInverseProperty(),m_ranOverBy);
        assertSame(m_ranOverBy.getInverseProperty(),m_runsOver);
    }
    public void testAddSubProperty() throws Exception {
        assertNotInModel(m_noDomainNoRange.getURI(),getVocabularyAdaptor().getSubPropertyOf(),m_owns.getURI(),false);
        applyChange(new AddSubProperty(m_owns,m_noDomainNoRange));
        assertInModel(m_noDomainNoRange.getURI(),getVocabularyAdaptor().getSubPropertyOf(),m_owns.getURI(),false);
        Set subproperties=m_owns.getSubProperties();
        assertEquals(1,subproperties.size());
        assertTrue(subproperties.contains(m_noDomainNoRange));
        Set superproperties=m_noDomainNoRange.getSuperProperties();
        assertEquals(1,superproperties.size());
        assertTrue(superproperties.contains(m_owns));
    }
    public void testAddSubProperties() throws Exception {
        assertEquals(0,m_owns.getSubProperties().size());
        assertEquals(0,m_noDomainNoRange.getSuperProperties().size());
        assertNotInModel(m_noDomainNoRange.getURI(),getVocabularyAdaptor().getSubPropertyOf(),m_owns.getURI(),false);
        applyChange(new AddSubProperty(m_owns,m_noDomainNoRange));
        assertInModel(m_noDomainNoRange.getURI(),getVocabularyAdaptor().getSubPropertyOf(),m_owns.getURI(),false);
        assertEquals(1,m_owns.getSubProperties().size());
        assertEquals(1,m_noDomainNoRange.getSuperProperties().size());
        assertTrue(m_noDomainNoRange.getSuperProperties().contains(m_owns));
    }
    public void testRemoveSubProperty() throws Exception {
        assertEquals(1,m_runsOver.getSubProperties().size());
        assertTrue(m_runsOver.getSubProperties().contains(m_BMWRunsOverCat));
        assertEquals(1,m_BMWRunsOverCat.getSuperProperties().size());
        assertTrue(m_BMWRunsOverCat.getSuperProperties().contains(m_runsOver));
        assertInModel(m_BMWRunsOverCat.getURI(),getVocabularyAdaptor().getSubPropertyOf(),m_runsOver.getURI(),false);
        applyChange(new RemoveSubProperty(m_runsOver,m_BMWRunsOverCat));
        assertNotInModel(m_BMWRunsOverCat.getURI(),getVocabularyAdaptor().getSubPropertyOf(),m_runsOver.getURI(),false);
        assertEquals(0,m_runsOver.getSubProperties().size());
        assertEquals(0,m_BMWRunsOverCat.getSuperProperties().size());
    }
    public void testCreateProperty() throws Exception {
        Property likes2=m_oimodel.getProperty("test:likes2");
        assertTrue(!likes2.isInOIModel());
        assertNotInModel(likes2.getURI(),getVocabularyAdaptor().getInstanceOf(),getVocabularyAdaptor().getProperty(),false);
        applyChange(new AddEntity(likes2));
        assertInModel(likes2.getURI(),getVocabularyAdaptor().getInstanceOf(),getVocabularyAdaptor().getProperty(),false);
        assertTrue(likes2.isInOIModel());
    }
    public void testDeleteProperty() throws Exception {
        assertInModel(m_BMWRunsOverJaguar.getURI(),getVocabularyAdaptor().getInstanceOf(),getVocabularyAdaptor().getProperty(),false);
        assertInModel(m_BMWRunsOverJaguar.getURI(),getVocabularyAdaptor().getSubPropertyOf(),m_BMWRunsOverCat.getURI(),false);
        applyChanges(new ChangeEvent[] { new RemoveSubProperty(m_BMWRunsOverCat,m_BMWRunsOverJaguar),new RemoveEntity(m_BMWRunsOverJaguar) });
        assertNotInModel(m_BMWRunsOverJaguar.getURI(),getVocabularyAdaptor().getInstanceOf(),getVocabularyAdaptor().getProperty(),false);
        assertNotInModel(m_BMWRunsOverJaguar.getURI(),getVocabularyAdaptor().getSubPropertyOf(),m_BMWRunsOverCat.getURI(),false);
        assertTrue(!m_BMWRunsOverCat.getSubProperties().contains(m_BMWRunsOverJaguar));
        assertTrue(!m_BMWRunsOverJaguar.getSuperProperties().contains(m_BMWRunsOverCat));
        assertTrue(!m_BMWRunsOverJaguar.isInOIModel());
    }
    public void testSetNoInverseProperties() throws Exception {
        assertSame(m_runsOver.getInverseProperty(),m_ranOverBy);
        assertSame(m_ranOverBy.getInverseProperty(),m_runsOver);
        applyChange(new SetNoInverseProperties(m_runsOver,m_ranOverBy));
        assertNotInModel(m_runsOver.getURI(),getVocabularyAdaptor().getInverse(),m_ranOverBy.getURI(),false);
        assertNotInModel(m_ranOverBy.getURI(),getVocabularyAdaptor().getInverse(),m_runsOver.getURI(),false);
        assertNull(m_runsOver.getInverseProperty());
        assertNull(m_ranOverBy.getInverseProperty());
    }
    public void testSetInverseProperties() throws Exception {
        assertNull(m_owns.getInverseProperty());
        assertNull(m_ownedBy.getInverseProperty());
        applyChange(new SetInverseProperties(m_owns,m_ownedBy));
        assertInModel(m_owns.getURI(),getVocabularyAdaptor().getInverse(),m_ownedBy.getURI(),false);
        assertInModel(m_ownedBy.getURI(),getVocabularyAdaptor().getInverse(),m_owns.getURI(),false);
        assertSame(m_owns.getInverseProperty(),m_ownedBy);
        assertSame(m_ownedBy.getInverseProperty(),m_owns);
    }
    public void testSetSymmetricProperty() throws Exception {
        assertTrue(!m_runsOver.isSymmetric());
        applyChange(new SetPropertySymmetric(m_runsOver,true));
        assertInModel(m_runsOver.getURI(),getVocabularyAdaptor().getSymmetric(),"true",true);
        assertTrue(m_runsOver.isSymmetric());
    }
    public void testSetTransitiveProperty() throws Exception {
        assertTrue(!m_runsOver.isTransitive());
        applyChange(new SetPropertyTransitive(m_runsOver,true));
        assertInModel(m_runsOver.getURI(),getVocabularyAdaptor().getTransitive(),"true",true);
        assertTrue(m_runsOver.isTransitive());
    }
    public void testResetSymmetricProperty() throws Exception {
        assertTrue(m_likes.isSymmetric());
        assertInModel(m_likes.getURI(),getVocabularyAdaptor().getSymmetric(),"true",true);
        applyChange(new SetPropertySymmetric(m_likes,false));
        assertNotInModel(m_likes.getURI(),getVocabularyAdaptor().getSymmetric(),"true",true);
        assertTrue(!m_likes.isSymmetric());
    }
    public void testResetTransitiveProperty() throws Exception {
        assertTrue(m_likes.isTransitive());
        assertInModel(m_likes.getURI(),getVocabularyAdaptor().getTransitive(),"true",true);
        applyChange(new SetPropertyTransitive(m_likes,false));
        assertNotInModel(m_likes.getURI(),getVocabularyAdaptor().getTransitive(),"true",true);
        assertTrue(!m_likes.isTransitive());
    }
    public void testSetIsAttribute() throws Exception {
        assertNotInModel(m_noDomainNoRange.getURI(),getVocabularyAdaptor().getRange(),getVocabularyAdaptor().getLiteral(),false);
        applyChange(new SetPropertyIsAttribute(m_noDomainNoRange,true));
        assertInModel(m_noDomainNoRange.getURI(),getVocabularyAdaptor().getRange(),getVocabularyAdaptor().getLiteral(),false);
        assertTrue(m_noDomainNoRange.isAttribute());
    }
    public void testSetIsNotAttribute() throws Exception {
        assertInModel(m_wheelsNo.getURI(),getVocabularyAdaptor().getRange(),getVocabularyAdaptor().getLiteral(),false);
        applyChange(new SetPropertyIsAttribute(m_wheelsNo,false));
        assertNotInModel(m_wheelsNo.getURI(),getVocabularyAdaptor().getRange(),getVocabularyAdaptor().getLiteral(),false);
        assertTrue(!m_wheelsNo.isAttribute());
    }
    public void testGetAllProperties() throws Exception {
        Set properties=m_oimodel.getProperties();
        assertEquals(11,properties.size());
        assertTrue(properties.contains(m_color));
        assertTrue(properties.contains(m_wheelsNo));
        assertTrue(properties.contains(m_runsOver));
        assertTrue(properties.contains(m_ranOverBy));
        assertTrue(properties.contains(m_BMWRunsOverCat));
        assertTrue(properties.contains(m_BMWRunsOverJaguar));
        assertTrue(properties.contains(m_friendsWithoutIt));
        assertTrue(properties.contains(m_owns));
        assertTrue(properties.contains(m_ownedBy));
        assertTrue(properties.contains(m_likes));
        assertTrue(properties.contains(m_noDomainNoRange));
    }
}
