package edu.unika.aifb.kaon.apionrdf.test;

import java.net.URL;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Tests based on res/people.xml.
 */
public class PeopleXMLTest extends SingleModelTest {
    protected static Model s_peopleModel;
    static {
        try {
            s_peopleModel=RDFManager.openModel(JaguarXMLTest.class.getResource("res/people.xml").toString(),null);
        }
        catch (Exception e) {
            e.printStackTrace();
            s_peopleModel=null;
        }
    }

    protected Concept m_person;
    protected Property m_friendOf;
    protected Property m_parentOf;
    protected Property m_childOf;
    protected Property m_ancestorOf;
    protected Property m_descendantOf;
    protected Instance m_Grangrandad;
    protected Instance m_Grandad1;
    protected Instance m_Grandad2;
    protected Instance m_Dad11;
    protected Instance m_Dad21;
    protected Instance m_Dad22;

    public PeopleXMLTest(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        super.setUp();
        m_person=m_oimodel.getConcept("test:person");
        m_friendOf=m_oimodel.getProperty("test:friendOf");
        m_parentOf=m_oimodel.getProperty("test:parentOf");
        m_childOf=m_oimodel.getProperty("test:childOf");
        m_ancestorOf=m_oimodel.getProperty("test:ancestorOf");
        m_descendantOf=m_oimodel.getProperty("test:descendantOf");
        m_Grangrandad=m_oimodel.getInstance("test:Grangrandad");
        m_Grandad1=m_oimodel.getInstance("test:Grandad1");
        m_Grandad2=m_oimodel.getInstance("test:Grandad2");
        m_Dad11=m_oimodel.getInstance("test:Dad11");
        m_Dad21=m_oimodel.getInstance("test:Dad21");
        m_Dad22=m_oimodel.getInstance("test:Dad22");
    }
    protected Model getDefaultModel() {
        return s_peopleModel;
    }
}
