package edu.unika.aifb.kaon.apionrdf.test;

import java.util.List;
import java.util.Collections;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

import edu.unika.aifb.kaon.apionrdf.*;

public class ModularizationTest extends BaseTest {
    protected Model m_ontologyModel;
    protected Model m_instancesModel;
    protected OIModel m_ontology;
    protected OIModel m_instances;

    public ModularizationTest(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        m_ontologyModel=RDFManager.openModel(ModularizationTest.class.getResource("res/ontology.xml").toString(),null);
        m_instancesModel=RDFManager.openModel(ModularizationTest.class.getResource("res/instances.xml").toString(),null);
        KAONConnectionImpl connection=new KAONConnectionImpl();
        m_ontology=connection.getOIModelForRDFModel(m_ontologyModel);
        m_instances=connection.getOIModelForRDFModel(m_instancesModel);
        m_instances.applyChanges(Collections.singletonList(new AddIncludedOIModel(m_ontology)));
    }
    public void testConstraints() throws Exception {
        assertTrue(m_instancesModel.getIncludedModels().contains(m_ontologyModel));
        assertTrue(m_instances.getIncludedOIModels().contains(m_ontology));
    }
    public void testOntologyContents() throws Exception {
        Concept root=m_ontology.getRootConcept();
        Concept person=m_ontology.getConcept("onto:person");
        Concept mother=m_ontology.getConcept("onto:person");
        Property name=m_ontology.getProperty("onto:name");
        Property weight=m_ontology.getProperty("onto:weight");
        Property friendOf=m_ontology.getProperty("onto:friendOf");
        Instance god=m_ontology.getInstance("inst:god");
        // now for the tests
        assertSetEquals(m_ontology.getConcepts(),new Object[] { root,person,mother });
        assertSetEquals(m_ontology.getProperties(),new Object[] { name,weight,friendOf });
        assertSetEquals(person.getAllInstances(),new Object[] { god });
        assertSetEquals(god.getAllFromPropertyValues(friendOf),null);
        // now for the subclassing
        assertTrue(!mother.isDirectSubConceptOf(person));
        assertTrue(!person.isDirectSubConceptOf(mother));
    }
    public void testInstancesContents() throws Exception {
        Concept root=m_instances.getRootConcept();
        Concept person=m_instances.getConcept("onto:person");
        Concept mother=m_instances.getConcept("onto:mother");
        Concept dog=m_instances.getConcept("onto:dog");
        Property name=m_instances.getProperty("onto:name");
        Property weight=m_instances.getProperty("onto:weight");
        Property friendOf=m_instances.getProperty("onto:friendOf");
        Property owns=m_instances.getProperty("onto:owns");
        Property ownedBy=m_instances.getProperty("onto:ownedBy");
        Instance god=m_instances.getInstance("inst:god");
        Instance A=m_instances.getInstance("inst:A");
        Instance B=m_instances.getInstance("inst:B");
        Instance C=m_instances.getInstance("inst:C");
        Instance D=m_instances.getInstance("inst:D");
        // now for the tests
        assertSetEquals(m_instances.getConcepts(),new Object[] { root,person,mother,dog });
        assertSetEquals(m_instances.getProperties(),new Object[] { name,weight,friendOf,owns,ownedBy });
        assertSetEquals(person.getAllInstances(),new Object[] { god,A,B,C,D });
        assertSetEquals(god.getAllFromPropertyValues(friendOf),new Object[] { D });
        // now for the subclassing
        assertTrue(mother.isDirectSubConceptOf(person));
        assertTrue(!person.isDirectSubConceptOf(mother));
    }
    public void testAddConceptToOntology() throws Exception {
        // now test various objects and perform update
        Concept newOntologyConcept=m_ontology.getConcept("onto:ape");
        Concept newInstancesConcept=m_instances.getConcept("onto:ape");
        assertTrue(!newOntologyConcept.isInOIModel());
        assertTrue(!newInstancesConcept.isInOIModel());
        m_ontology.applyChanges(Collections.singletonList(new AddEntity(newOntologyConcept)));
        // now thest the original model
        assertTrue(newOntologyConcept.isInOIModel());
        assertTrue(newInstancesConcept.isInOIModel());
        assertInModel(m_ontologyModel,"onto:ape",RDF+"type",RDFS+"Class",false);
        // break the inclusion and test where the statement was actually added
        m_instancesModel.removeIncludedModel(m_ontologyModel);
        assertNotInModel(m_instancesModel,"onto:ape",RDF+"type",RDFS+"Class",false);
    }
    public void testAddConceptToInstances() throws Exception {
        Concept newOntologyConcept=m_ontology.getConcept("onto:ape");
        Concept newInstancesConcept=m_instances.getConcept("onto:ape");
        assertTrue(!newOntologyConcept.isInOIModel());
        assertTrue(!newInstancesConcept.isInOIModel());
        m_instances.applyChanges(Collections.singletonList(new AddEntity(newInstancesConcept)));
        assertTrue(!newOntologyConcept.isInOIModel());
        assertTrue(newInstancesConcept.isInOIModel());
        assertNotInModel(m_ontologyModel,"onto:ape",RDF+"type",RDFS+"Class",false);
        assertInModel(m_instancesModel,"onto:ape",RDF+"type",RDFS+"Class",false);
    }
    public void testIsDeclaredLocally() throws Exception {
        Concept ontologyPerson=m_ontology.getConcept("onto:person");
        assertTrue(ontologyPerson.isDeclaredLocally());
        assertSame(m_ontology,ontologyPerson.getSourceOIModel());
        assertSame(ontologyPerson.getOIModel(),ontologyPerson.getSourceOIModel());
        Instance ontologyPersonSpanningInstance=ontologyPerson.getSpanningInstance();
        assertTrue(ontologyPersonSpanningInstance.isDeclaredLocally());
        assertSame(m_ontology,ontologyPersonSpanningInstance.getSourceOIModel());
        assertSame(ontologyPersonSpanningInstance.getOIModel(),ontologyPersonSpanningInstance.getSourceOIModel());
        Concept instancePerson=m_instances.getConcept("onto:person");
        assertTrue(!instancePerson.isDeclaredLocally());
        assertSame(m_ontology,instancePerson.getSourceOIModel());
        Instance instancePersonSpanningInstance=instancePerson.getSpanningInstance();
        assertTrue(!instancePersonSpanningInstance.isDeclaredLocally());
        assertSame(m_ontology,instancePersonSpanningInstance.getSourceOIModel());
        Concept notInModel=m_ontology.getConcept("onto:notInModel");
        assertTrue(!notInModel.isDeclaredLocally());
        assertNull(notInModel.getSourceOIModel());
    }
    public void testSubConcept() throws Exception {
        Concept person=m_instances.getConcept("onto:person");
        Concept mother=m_instances.getConcept("onto:mother");
        assertSame(m_instances,mother.getSuperSubConceptOIModel(person));
        assertTrue(mother.isSuperSubConceptDeclaredLocally(person));
    }
    public void testChangeIncludedModel() throws Exception {
        Property friendOf=m_ontology.getProperty("onto:friendOf");
        Property name=m_ontology.getProperty("onto:name");
        m_ontology.applyChanges(Collections.singletonList(new SetInverseProperties(friendOf,name)));
        assertTrue(friendOf.getInverseProperty()==name);
        assertTrue(name.getInverseProperty()==friendOf);
        m_ontology.applyChanges(Collections.singletonList(new SetNoInverseProperties(friendOf,name)));
        assertNull(friendOf.getInverseProperty());
        assertNull(name.getInverseProperty());
    }
}
