package edu.unika.aifb.kaon.apionrdf.test;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Collections;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.apionrdf.*;

public class Modularization2Test extends BaseTest {
    protected KAONConnectionImpl m_kaonConnection;
    protected OIModelImpl m_oimodel_A;
    protected OIModelImpl m_oimodel_B_A;
    protected OIModelImpl m_oimodel_C_A;
    protected OIModelImpl m_oimodel_D_B_C_A;
    protected OIModelImpl m_oimodel_E_B_A;
    protected Listener m_listener_A;
    protected Listener m_listener_B_A;
    protected Listener m_listener_C_A;
    protected Listener m_listener_D_B_C_A;
    protected Listener m_listener_E_B_A;

    public Modularization2Test(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        m_kaonConnection=new KAONConnectionImpl();
        m_oimodel_A=(OIModelImpl)m_kaonConnection.createOIModel("file:/c:/temp/a.kaon","file:/c:/temp/a.kaon");
        m_oimodel_B_A=(OIModelImpl)m_kaonConnection.createOIModel("file:/c:/temp/b.kaon","file:/c:/temp/b.kaon");
        m_oimodel_B_A.applyChanges(Collections.singletonList(new AddIncludedOIModel(m_oimodel_A)));
        m_oimodel_C_A=(OIModelImpl)m_kaonConnection.createOIModel("file:/c:/temp/c.kaon","file:/c:/temp/c.kaon");
        m_oimodel_C_A.applyChanges(Collections.singletonList(new AddIncludedOIModel(m_oimodel_A)));
        m_oimodel_D_B_C_A=(OIModelImpl)m_kaonConnection.createOIModel("file:/c:/temp/d.kaon","file:/c:/temp/d.kaon");
        m_oimodel_D_B_C_A.applyChanges(Collections.singletonList(new AddIncludedOIModel(m_oimodel_B_A)));
        m_oimodel_D_B_C_A.applyChanges(Collections.singletonList(new AddIncludedOIModel(m_oimodel_C_A)));
        m_oimodel_E_B_A=(OIModelImpl)m_kaonConnection.createOIModel("file:/c:/temp/e.kaon","file:/c:/temp/e.kaon");
        m_oimodel_E_B_A.applyChanges(Collections.singletonList(new AddIncludedOIModel(m_oimodel_B_A)));
        m_listener_A=new Listener(m_oimodel_A);
        m_listener_B_A=new Listener(m_oimodel_B_A);
        m_listener_C_A=new Listener(m_oimodel_C_A);
        m_listener_D_B_C_A=new Listener(m_oimodel_D_B_C_A);
        m_listener_E_B_A=new Listener(m_oimodel_E_B_A);
    }
    protected void changeOIModel(OIModel oimodel,ChangeEvent[] events) throws Exception {
        List list=new LinkedList();
        for (int i=0;i<events.length;i++)
            list.add(events[i]);
        oimodel.applyChanges(list);
    }
    protected ChangeEvent changeInModel(ChangeEvent changeEvent,OIModel oimodel) {
        changeEvent.setOIModel(oimodel);
        return changeEvent;
    }
    public void testIncludedBy() throws Exception {
        assertSetEquals(m_oimodel_A.getAllIncludedByOIModels(),new Object[] { m_oimodel_B_A,m_oimodel_C_A,m_oimodel_D_B_C_A,m_oimodel_E_B_A });
        assertSetEquals(m_oimodel_B_A.getAllIncludedByOIModels(),new Object[] { m_oimodel_D_B_C_A,m_oimodel_E_B_A });
        assertSetEquals(m_oimodel_C_A.getAllIncludedByOIModels(),new Object[] { m_oimodel_D_B_C_A });
        assertSetEquals(m_oimodel_D_B_C_A.getAllIncludedByOIModels(),new Object[] { });
        assertSetEquals(m_oimodel_E_B_A.getAllIncludedByOIModels(),new Object[] { });
    }
    public void testRemoveIncludedBy() throws Exception {
        m_oimodel_B_A.applyChanges(Collections.singletonList(new RemoveIncludedOIModel(m_oimodel_A)));
        assertSetEquals(m_oimodel_A.getAllIncludedByOIModels(),new Object[] { m_oimodel_C_A,m_oimodel_D_B_C_A });
        assertSetEquals(m_oimodel_B_A.getAllIncludedByOIModels(),new Object[] { m_oimodel_D_B_C_A,m_oimodel_E_B_A });
        assertSetEquals(m_oimodel_C_A.getAllIncludedByOIModels(),new Object[] { m_oimodel_D_B_C_A });
        assertSetEquals(m_oimodel_D_B_C_A.getAllIncludedByOIModels(),new Object[] { });
        assertSetEquals(m_oimodel_E_B_A.getAllIncludedByOIModels(),new Object[] { });
    }
    public void testChange_A() throws Exception {
        Concept c_A=m_oimodel_A.getConcept("c");
        changeOIModel(m_oimodel_A,new ChangeEvent[] { new AddEntity(c_A),new AddSubConcept(m_oimodel_A.getRootConcept(),c_A) });
        m_listener_A.assertSize(2);
        m_listener_B_A.assertSize(2);
        m_listener_C_A.assertSize(2);
        m_listener_D_B_C_A.assertSize(2);
        m_listener_E_B_A.assertSize(2);
        AddEntity e1=(AddEntity)m_listener_E_B_A.next();
        assertSame(m_oimodel_E_B_A,e1.getEntity().getOIModel());
        assertTrue(c_A!=e1.getEntity());
        assertEquals(c_A.getURI(),e1.getEntity().getURI());
    }
    public void testChange_B_A() throws Exception {
        Concept c_B_A=m_oimodel_B_A.getConcept("c");
        changeOIModel(m_oimodel_B_A,new ChangeEvent[] { new AddEntity(c_B_A),new AddSubConcept(m_oimodel_B_A.getRootConcept(),c_B_A) });
        m_listener_A.assertSize(0);
        m_listener_B_A.assertSize(2);
        m_listener_C_A.assertSize(0);
        m_listener_D_B_C_A.assertSize(2);
        m_listener_E_B_A.assertSize(2);
        AddEntity e1=(AddEntity)m_listener_E_B_A.next();
        assertSame(m_oimodel_E_B_A,e1.getEntity().getOIModel());
    }
    public void testMultiModelChange1() throws Exception {
        List list=new LinkedList();
        Concept c_B_A=m_oimodel_B_A.getConcept("c");
        Concept c_E_B_A=m_oimodel_E_B_A.getConcept("c");
        Instance i_E_B_A=m_oimodel_E_B_A.getInstance("i");
        Concept d_C_A=m_oimodel_C_A.getConcept("d");
        list.add(changeInModel(new AddEntity(c_B_A),m_oimodel_B_A));
        list.add(changeInModel(new AddSubConcept(m_oimodel_B_A.getRootConcept(),c_B_A),m_oimodel_B_A));
        list.add(changeInModel(new AddEntity(i_E_B_A),m_oimodel_E_B_A));
        list.add(changeInModel(new AddInstanceOf(c_E_B_A,i_E_B_A),m_oimodel_E_B_A));
        list.add(changeInModel(new AddEntity(d_C_A),m_oimodel_C_A));
        list.add(changeInModel(new AddSubConcept(m_oimodel_C_A.getRootConcept(),d_C_A),m_oimodel_C_A));
        m_kaonConnection.applyChanges(list);
        m_listener_A.assertSize(0);
        m_listener_B_A.assertSize(2);
        m_listener_C_A.assertSize(2);
        m_listener_D_B_C_A.assertSize(4);
        m_listener_E_B_A.assertSize(4);
        assertTrue(m_listener_E_B_A.next() instanceof AddEntity);
        assertTrue(m_listener_E_B_A.next() instanceof AddSubConcept);
        assertTrue(m_listener_E_B_A.next() instanceof AddEntity);
        assertTrue(m_listener_E_B_A.next() instanceof AddInstanceOf);
        assertTrue(m_listener_D_B_C_A.next() instanceof AddEntity);
        assertTrue(m_listener_D_B_C_A.next() instanceof AddSubConcept);
        assertTrue(m_listener_D_B_C_A.next() instanceof AddEntity);
        assertTrue(m_listener_D_B_C_A.next() instanceof AddSubConcept);
    }
    public void testMultiModelChange2() throws Exception {
        List list=new LinkedList();
        Concept c_B_A=m_oimodel_B_A.getConcept("c");
        Concept c_E_B_A=m_oimodel_E_B_A.getConcept("c");
        Instance i_E_B_A=m_oimodel_E_B_A.getInstance("i");
        Concept d_A=m_oimodel_A.getConcept("d");
        list.add(changeInModel(new AddEntity(c_B_A),m_oimodel_B_A));
        list.add(changeInModel(new AddSubConcept(m_oimodel_B_A.getRootConcept(),c_B_A),m_oimodel_B_A));
        list.add(changeInModel(new AddEntity(i_E_B_A),m_oimodel_E_B_A));
        list.add(changeInModel(new AddInstanceOf(c_E_B_A,i_E_B_A),m_oimodel_E_B_A));
        list.add(changeInModel(new AddEntity(d_A),m_oimodel_A));
        list.add(changeInModel(new AddSubConcept(m_oimodel_A.getRootConcept(),d_A),m_oimodel_A));
        m_kaonConnection.applyChanges(list);
        m_listener_A.assertSize(2);
        m_listener_B_A.assertSize(4);
        m_listener_C_A.assertSize(2);
        m_listener_D_B_C_A.assertSize(4);
        m_listener_E_B_A.assertSize(6);
        assertTrue(m_listener_E_B_A.next() instanceof AddEntity);
        assertTrue(m_listener_E_B_A.next() instanceof AddSubConcept);
        assertTrue(m_listener_E_B_A.next() instanceof AddEntity);
        assertTrue(m_listener_E_B_A.next() instanceof AddInstanceOf);
        assertTrue(m_listener_E_B_A.next() instanceof AddEntity);
        assertTrue(m_listener_E_B_A.next() instanceof AddSubConcept);
    }

    protected class Listener implements OIModelListener {
        protected List m_events;
        protected Iterator m_iterator;

        public Listener(OIModel oimodel) {
            oimodel.addOIModelListener(this);
            m_events=new LinkedList();
        }
        public void modelChanged(OIModel oimodel,List changeEvents) {
            m_events.clear();
            m_iterator=null;
            m_events.addAll(changeEvents);
        }
        public void modelRefreshed(OIModel oimodel) {
        }
        public void modelDeleted(OIModel oimodel) {
        }
        public void assertSize(int size) throws Exception {
            assertEquals(size,m_events.size());
        }
        public ChangeEvent next() {
            if (m_iterator==null)
                m_iterator=m_events.iterator();
            return (ChangeEvent)m_iterator.next();
        }
    }
}
