package edu.unika.aifb.kaon.apionrdf.test;

import java.util.Set;
import java.util.Map;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

public class MetamodelingTest extends ApeXMLTest {

    public MetamodelingTest(String name) {
        super(name);
    }
    public void testInModel() throws Exception {
        assertTrue(m_foodType.isInOIModel());
        assertTrue(m_food.isInOIModel());
        assertTrue(m_species.isInOIModel());
        assertTrue(m_animal.isInOIModel());
        assertTrue(m_ape_concept.isInOIModel());
        assertTrue(m_bannana_concept.isInOIModel());
        assertTrue(m_feedsOn.isInOIModel());
        assertTrue(m_hasEaten.isInOIModel());
        assertTrue(m_age.isInOIModel());
        assertTrue(m_ape_instance.isInOIModel());
        assertTrue(m_bannana_instance.isInOIModel());
        assertTrue(m_bannana1.isInOIModel());
        assertTrue(m_Nkima.isInOIModel());
    }
    public void testSpanningConceptInstance() throws Exception {
        assertSame(m_ape_concept,m_ape_instance.getSpanningConcept());
        assertSame(m_ape_concept.getSpanningInstance(),m_ape_instance);
        assertSame(m_bannana_concept,m_bannana_instance.getSpanningConcept());
        assertSame(m_bannana_concept.getSpanningInstance(),m_bannana_instance);
    }
    public void testMetaConcept() throws Exception {
        // test species
        assertSetEquals(m_species.getSuperConcepts(),new Object[] { m_Root });
        assertSetEquals(m_species.getSubConcepts(),null);
        assertSetEquals(m_species.getInstances(),new Object[] { m_ape_instance });
        assertSetEquals(m_species.getPropertiesFromConcept(),new Object[] { m_feedsOn });
        assertSetEquals(m_species.getPropertiesToConcept(),null);
        assertTrue(m_species.getSpanningInstance().isInOIModel());
        // test foodType
        assertSetEquals(m_foodType.getSuperConcepts(),new Object[] { m_Root });
        assertSetEquals(m_foodType.getSubConcepts(),null);
        assertSetEquals(m_foodType.getInstances(),new Object[] { m_bannana_instance });
        assertSetEquals(m_foodType.getPropertiesFromConcept(),null);
        assertSetEquals(m_foodType.getPropertiesToConcept(),new Object[] { m_feedsOn });
        assertTrue(m_foodType.getSpanningInstance().isInOIModel());
    }
    public void testMiddleConcept() throws Exception {
        // test the ape class
        assertSetEquals(m_ape_concept.getSuperConcepts(),new Object[] { m_animal });
        assertSetEquals(m_ape_concept.getSubConcepts(),null);
        assertSetEquals(m_ape_concept.getPropertiesFromConcept(),new Object[] { m_age });
        assertSetEquals(m_ape_concept.getAllPropertiesFromConcept(),new Object[] { m_age,m_hasEaten });
        assertSetEquals(m_ape_concept.getPropertiesToConcept(),null);
        assertSetEquals(m_ape_concept.getAllPropertiesToConcept(),null);
        // test the bannana class
        assertSetEquals(m_bannana_concept.getSuperConcepts(),new Object[] { m_food });
        assertSetEquals(m_bannana_concept.getSubConcepts(),null);
        assertSetEquals(m_bannana_concept.getPropertiesFromConcept(),null);
        assertSetEquals(m_bannana_concept.getAllPropertiesFromConcept(),null);
        assertSetEquals(m_bannana_concept.getPropertiesToConcept(),null);
        assertSetEquals(m_bannana_concept.getAllPropertiesToConcept(),new Object[] { m_hasEaten });
        // test the age property
        assertSetEquals(m_age.getDomainConcepts(),new Object[] { m_ape_concept });
        assertSetEquals(m_age.getRangeConcepts(),null);
        assertTrue(m_age.isAttribute());
    }
    public void testMiddleInstance() throws Exception {
        // test the ape instance
        assertSetEquals(m_ape_instance.getParentConcepts(),new Object[] { m_species,m_Root });
        assertSetEquals(m_ape_instance.getFromPropertyValues(m_feedsOn),new Object[] { m_bannana_instance });
        assertSetEquals(m_ape_instance.getAllFromPropertyValues(m_feedsOn),new Object[] { m_bannana_instance });
        assertSetEquals(m_ape_instance.getFromPropertyInstances(),new Object[] { m_oimodel.getPropertyInstance(m_feedsOn,m_ape_instance,m_bannana_instance) });
        Map map=m_ape_instance.getFromPropertyValues();
        assertEquals(1,map.size());
        assertSetEquals((Set)map.get(m_feedsOn),new Object[] { m_bannana_instance });
        assertSetEquals(m_ape_instance.getToPropertyInstances(),null);
        assertEquals(0,m_ape_instance.getToPropertyValues().size());
        // test the bannana instance
        assertSetEquals(m_bannana_instance.getParentConcepts(),new Object[] { m_foodType,m_Root });
        assertSetEquals(m_bannana_instance.getFromPropertyInstances(),null);
        assertEquals(0,m_bannana_instance.getFromPropertyValues().size());
        assertSetEquals(m_bannana_instance.getToPropertyInstances(),new Object[] { m_oimodel.getPropertyInstance(m_feedsOn,m_ape_instance,m_bannana_instance) });
        map=m_bannana_instance.getToPropertyValues();
        assertEquals(1,map.size());
        assertSetEquals((Set)map.get(m_feedsOn),new Object[] { m_ape_instance });
    }
    public void testLeafInstances() throws Exception {
        // test the Nkima instance
        assertSetEquals(m_Nkima.getParentConcepts(),new Object[] { m_ape_concept,m_Root });
        assertSetEquals(m_Nkima.getFromPropertyValues(m_hasEaten),new Object[] { m_bannana1 });
        assertSetEquals(m_Nkima.getAllFromPropertyValues(m_hasEaten),new Object[] { m_bannana1 });
        assertSetEquals(m_Nkima.getFromPropertyInstances(),new Object[] { m_oimodel.getPropertyInstance(m_hasEaten,m_Nkima,m_bannana1) });
        Map map=m_Nkima.getFromPropertyValues();
        assertEquals(1,map.size());
        assertSetEquals((Set)map.get(m_hasEaten),new Object[] { m_bannana1 });
        assertSetEquals(m_Nkima.getToPropertyInstances(),null);
        assertEquals(0,m_Nkima.getToPropertyValues().size());
        // test the bannana1 instances
        assertSetEquals(m_bannana1.getParentConcepts(),new Object[] { m_bannana_concept,m_Root });
        assertSetEquals(m_bannana1.getFromPropertyInstances(),null);
        assertEquals(0,m_bannana1.getFromPropertyValues().size());
        assertSetEquals(m_bannana1.getToPropertyInstances(),new Object[] { m_oimodel.getPropertyInstance(m_hasEaten,m_Nkima,m_bannana1) });
        assertSetEquals(m_bannana1.getToPropertyValues(m_hasEaten),new Object[] { m_Nkima });
        map=m_bannana1.getToPropertyValues();
        assertEquals(1,map.size());
        assertSetEquals((Set)map.get(m_hasEaten),new Object[] { m_Nkima });
    }
    public void testPropertyNoMetaClass() throws Exception {
        Instance instance=m_feedsOn.getSpanningInstance();
        assertSetEquals(instance.getParentConcepts(),new Object[] { m_Root });
        assertSetEquals(instance.getFromPropertyInstances(),null);
        assertSetEquals(instance.getToPropertyInstances(),null);
        assertTrue(instance.isInOIModel());
    }
    public void testModelContents() throws Exception {
        assertSetEquals(m_oimodel.getConcepts(),new Object[] { m_Root,m_species,m_animal,m_ape_concept,m_foodType,m_food,m_bannana_concept });
        assertSetEquals(m_oimodel.getProperties(),new Object[] { m_feedsOn,m_hasEaten,m_age });
    }
    public void testRootConceptSpanningInstance() throws Exception {
        assertTrue(!m_Root.getSpanningInstance().isInOIModel());
    }
    public void testRootConceptInstances() throws Exception {
        assertSetEquals(m_Root.getInstances(),new Object[] { m_species.getSpanningInstance(),m_animal.getSpanningInstance(),m_foodType.getSpanningInstance(),m_food.getSpanningInstance(),m_feedsOn.getSpanningInstance(),m_hasEaten.getSpanningInstance(),m_age.getSpanningInstance(),m_bannana_instance,m_ape_instance,m_bannana1,m_Nkima });
    }
}
