package edu.unika.aifb.kaon.apionrdf.test;

import java.util.Set;
import java.util.Map;
import java.util.Collections;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.vocabulary.*;
import edu.unika.aifb.kaon.api.util.*;

import edu.unika.aifb.kaon.apionrdf.*;

public class LexiconTest extends JaguarXMLTest {

    public LexiconTest(String name) {
        super(name);
    }
    protected void loadOIModel() throws Exception {
        KAONConnectionImpl connection=new KAONConnectionImpl();
        m_oimodel=connection.getOIModelForRDFModel(m_model);
        m_oimodel.applyChanges(Collections.singletonList(new AddIncludedOIModel(connection.openOIModelLogical(KAONConnection.LEXICAL_OIMODEL_URI))));
    }
    public void testLexicalEntryIdentity() throws Exception {
        assertTrue(m_jaguarLabelEN==m_oimodel.getLexicalEntry("test:jaguar_label_en"));
        assertTrue(m_jaguarLabelEN==m_oimodel.getLexicalEntry("test:jaguar_label_en"));
    }
    public void testReferencedEntities() throws Exception {
        assertSetEquals(m_jaguarLabelEN.getReferencedEntities(),new Object[] { m_jaguarCar.getSpanningInstance(),m_jaguarCat.getSpanningInstance(),m_jaguarCar1 });
    }
    public void testGetLexicalEntries() throws Exception {
        assertSetEquals(m_jaguarCar.getLexicalEntries(),new Object[] { m_jaguarLabelEN,m_jaguarLabelDE,m_carStemEN });
        assertSetEquals(m_jaguarCar1.getLexicalEntries(),new Object[] { m_jaguarLabelEN,m_jaguarLabelDE });
    }
    public void testGetLexicalEntriesByType() throws Exception {
        assertSetEquals(m_jaguarCar.getLexicalEntries(KAON_Label),new Object[] { m_jaguarLabelEN,m_jaguarLabelDE });
        assertSetEquals(m_jaguarCar.getLexicalEntries("non-existent"),null);
        assertSetEquals(m_jaguarCar1.getLexicalEntries(KAON_Label),new Object[] { m_jaguarLabelEN,m_jaguarLabelDE });
        assertSetEquals(m_jaguarCar1.getLexicalEntries("non-existent"),null);
    }
    public void testGetLexicalEntry() throws Exception {
        assertSame(m_jaguarCar.getLexicalEntry(KAON_Label,EN),m_jaguarLabelEN);
        assertNull(m_jaguarCar.getLexicalEntry(KAON_Stem,DE));
        assertSame(m_jaguarCar1.getLexicalEntry(KAON_Label,EN),m_jaguarLabelEN);
        assertNull(m_jaguarCar.getLexicalEntry(KAON_Stem,DE));
    }
    public void testLexicalAttribute() throws Exception {
        assertEquals("Jaguar auf Deutsch",m_jaguarCar.getLexicalAttribute(KAON_Label,DE,VALUE));
        assertEquals("Jaguar auf Deutsch",m_jaguarCar.getLabel(DE));
        assertNull(m_jaguarCar.getLexicalAttribute(KAON_Label,"russian",VALUE));
        assertEquals("Jaguar auf Deutsch",m_jaguarCar1.getLexicalAttribute(KAON_Label,DE,VALUE));
        assertEquals("Jaguar auf Deutsch",m_jaguarCar1.getLabel(DE));
        assertNull(m_jaguarCar1.getLexicalAttribute(KAON_Label,"russian",VALUE));
    }
    public void testGetTypeURI() throws Exception {
        assertEquals(KAON_Label,m_jaguarLabelDE.getTypeURI());
        assertEquals(KAON_Label,m_jaguarLabelDE.getTypeURI());
    }
    public void testGetAttributeURIs() throws Exception {
        assertSetEquals(m_carStemEN.getAttributeValues().keySet(),new Object[] { VALUE,KAON_inLanguage });
    }
    public void testGetAttribute() throws Exception {
        assertEquals("Car Stem",m_carStemEN.getAttribute(VALUE));
        Instance value=(Instance)m_carStemEN.getAttribute(KAONVocabularyAdaptor.INSTANCE.getReferences());
        assertTrue(value==m_jaguarCar.getSpanningInstance() || value==m_car.getSpanningInstance());
        assertEquals(m_oimodel.getInstance(EN),m_carStemEN.getAttribute(KAON_inLanguage));
        assertNull(m_carStemEN.getAttribute("non-existent"));
    }
    public void testCreateLexicalEntry() throws Exception {
        LexicalEntry lexicalEntry=m_oimodel.getLexicalEntry("test:new_lexical_entry");
        assertTrue(!lexicalEntry.isInOIModel());
        assertNotInModel(lexicalEntry.getURI(),RDF_instanceOf,KAON_Label,false);
        applyChanges(LexiconUtil.addLexicalEntry(lexicalEntry,KAON_Label));
        assertInModel(lexicalEntry.getURI(),RDF_instanceOf,KAON_Label,false);
        assertTrue(lexicalEntry.isInOIModel());
    }
    public void testAddLexicalReference() throws Exception {
        assertNotInModel(m_carStemEN.getURI(),KAON_references,m_MANN.getURI(),false);
        applyChanges(LexiconUtil.addLexicalReference(m_carStemEN,m_MANN));
        assertInModel(m_carStemEN.getURI(),KAON_references,m_MANN.getURI(),false);
        assertSetEquals(m_MANN.getLexicalEntries(),new Object[] { m_carStemEN });
        assertSetEquals(m_carStemEN.getReferencedEntities(),new Object[] { m_jaguarCar.getSpanningInstance(),m_car.getSpanningInstance(),m_MANN.getSpanningInstance() });
    }
    public void testRemoveLexicalReference() throws Exception {
        assertInModel(m_carStemEN.getURI(),KAON_references,m_car.getURI(),false);
        applyChanges(LexiconUtil.removeLexicalReference(m_carStemEN,m_car));
        assertNotInModel(m_carStemEN.getURI(),KAON_references,m_car.getURI(),false);
        assertSetEquals(m_car.getLexicalEntries(),null);
        assertSetEquals(m_carStemEN.getReferencedEntities(),new Object[] { m_jaguarCar.getSpanningInstance() });
    }
}
