package edu.unika.aifb.kaon.apionrdf.test;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Tests based on res/jaguar.xml.
 */
public class JaguarXMLTest extends SingleModelTest {
    protected static Model s_jaguarModel;
    static {
        try {
            s_jaguarModel=RDFManager.openModel(JaguarXMLTest.class.getResource("res/jaguar.xml").toString(),null);
        }
        catch (Exception e) {
            e.printStackTrace();
            s_jaguarModel=null;
        }
    }

    protected Concept m_Root;
    protected Concept m_statusSymbol;
    protected Concept m_car;
    protected Concept m_personalCar;
    protected Concept m_jaguarCar;
    protected Concept m_BMW;
    protected Concept m_truck;
    protected Concept m_MANN;
    protected Concept m_animal;
    protected Concept m_cat;
    protected Concept m_jaguarCat;
    protected Concept m_persianCat;
    protected Concept m_person;
    protected Property m_color;
    protected Property m_wheelsNo;
    protected Property m_runsOver;
    protected Property m_ranOverBy;
    protected Property m_BMWRunsOverCat;
    protected Property m_BMWRunsOverJaguar;
    protected Property m_friendsWithoutIt;
    protected Property m_owns;
    protected Property m_ownedBy;
    protected Property m_likes;
    protected Property m_noDomainNoRange;
    protected Instance m_jaguarCar1;
    protected Instance m_jaguarCar2;
    protected Instance m_Silvester;
    protected Instance m_Garfield;
    protected Instance m_Nermal;
    protected LexicalEntry m_jaguarLabelEN;
    protected LexicalEntry m_jaguarLabelDE;
    protected LexicalEntry m_carStemEN;

    public JaguarXMLTest(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        super.setUp();
        // concepts
        m_Root=m_oimodel.getConcept(getVocabularyAdaptor().getRoot());
        m_statusSymbol=m_oimodel.getConcept("test:status_symbol");
        m_car=m_oimodel.getConcept("test:car");
        m_personalCar=m_oimodel.getConcept("test:personal_car");
        m_jaguarCar=m_oimodel.getConcept("test:jaguar_car");
        m_BMW=m_oimodel.getConcept("test:BMW");
        m_truck=m_oimodel.getConcept("test:truck");
        m_MANN=m_oimodel.getConcept("test:MANN");
        m_animal=m_oimodel.getConcept("test:animal");
        m_cat=m_oimodel.getConcept("test:cat");
        m_jaguarCat=m_oimodel.getConcept("test:jaguar_cat");
        m_persianCat=m_oimodel.getConcept("test:persian_cat");
        m_person=m_oimodel.getConcept("test:person");
        // properteis
        m_color=m_oimodel.getProperty("test:color");
        m_wheelsNo=m_oimodel.getProperty("test:wheels_no");
        m_runsOver=m_oimodel.getProperty("test:runs_over");
        m_ranOverBy=m_oimodel.getProperty("test:ran_over_by");
        m_BMWRunsOverCat=m_oimodel.getProperty("test:BMW_runs_over_cat");
        m_BMWRunsOverJaguar=m_oimodel.getProperty("test:BMW_runs_over_jaguar");
        m_friendsWithoutIt=m_oimodel.getProperty("test:friends_without_it");
        m_owns=m_oimodel.getProperty("test:owns");
        m_ownedBy=m_oimodel.getProperty("test:owned_by");
        m_likes=m_oimodel.getProperty("test:likes");
        m_noDomainNoRange=m_oimodel.getProperty("test:no_domain_no_range");
        // instances
        m_jaguarCar1=m_oimodel.getInstance("test:jaguar_car_1");
        m_jaguarCar2=m_oimodel.getInstance("test:jaguar_car_2");
        m_Silvester=m_oimodel.getInstance("test:Silvester");
        m_Garfield=m_oimodel.getInstance("test:Garfield");
        m_Nermal=m_oimodel.getInstance("test:Nermal");
        // lexical entries
        m_jaguarLabelEN=m_oimodel.getLexicalEntry("test:jaguar_label_en");
        m_jaguarLabelDE=m_oimodel.getLexicalEntry("test:jaguar_label_de");
        m_carStemEN=m_oimodel.getLexicalEntry("test:car_stem_en");
    }
    protected Model getDefaultModel() {
        return s_jaguarModel;
    }
}
