package edu.unika.aifb.kaon.apionrdf.test;

import java.util.Set;
import java.util.Map;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

public class InstanceTest extends JaguarXMLTest {

    public InstanceTest(String name) {
        super(name);
    }
    public void testInstanceIdentity() throws Exception {
        assertTrue(m_Silvester==m_oimodel.getInstance("test:Silvester"));
    }
    public void testParentConcepts() throws Exception {
        assertSetEquals(m_Garfield.getParentConcepts(),new Object[] { m_persianCat,m_statusSymbol,m_Root });
    }
    public void testInstancesOfConcepts() throws Exception {
        assertSetEquals(m_persianCat.getInstances(),new Object[] { m_Garfield,m_Silvester,m_Nermal });
    }
    public void testFromPropertyInstances() throws Exception {
        Set set=m_jaguarCar1.getFromPropertyInstances();
        assertEquals(4,set.size());
        assertTrue(set.contains(m_oimodel.getPropertyInstance(m_color,m_jaguarCar1,"pink")));
        assertTrue(set.contains(m_oimodel.getPropertyInstance(m_wheelsNo,m_jaguarCar1,"6")));
        assertTrue(set.contains(m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Garfield)));
        assertTrue(set.contains(m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Silvester)));
    }
    public void testFromPropertyValues() throws Exception {
        Map map=m_jaguarCar1.getFromPropertyValues();
        assertEquals(3,map.size());
        Set set=(Set)map.get(m_color);
        assertEquals(1,set.size());
        assertTrue(set.contains("pink"));
        set=(Set)map.get(m_wheelsNo);
        assertEquals(1,set.size());
        assertTrue(set.contains("6"));
        set=(Set)map.get(m_runsOver);
        assertEquals(2,set.size());
        assertTrue(set.contains(m_Garfield));
        assertTrue(set.contains(m_Silvester));
    }
    public void testFromPropertyValue() throws Exception {
        assertEquals("pink",m_jaguarCar1.getFromPropertyValue(m_color));
        assertEquals("6",m_jaguarCar1.getFromPropertyValue(m_wheelsNo));
        Object value=m_jaguarCar1.getFromPropertyValue(m_runsOver);
        assertTrue(m_Silvester.equals(value) || m_Garfield.equals(value));
        assertEquals(m_Silvester,m_jaguarCar2.getFromPropertyValue(m_runsOver));
        assertNull(m_jaguarCar1.getFromPropertyValue(m_owns));
    }
    public void testFromPropertyValuesProperty() throws Exception {
        Set set=m_jaguarCar1.getFromPropertyValues(m_runsOver);
        assertEquals(2,set.size());
        assertTrue(set.contains(m_Silvester));
        assertTrue(set.contains(m_Garfield));
        set=m_jaguarCar1.getFromPropertyValues(m_owns);
        assertTrue(set.isEmpty());
    }
    public void testToPropertyInstances() throws Exception {
        Set set=m_Silvester.getToPropertyInstances();
        assertEquals(2,set.size());
        assertTrue(set.contains(m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Silvester)));
        assertTrue(set.contains(m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar2,m_Silvester)));
    }
    public void testToPropertyValues() throws Exception {
        Map map=m_Silvester.getToPropertyValues();
        assertEquals(1,map.size());
        Set set=(Set)map.get(m_runsOver);
        assertEquals(2,set.size());
        assertTrue(set.contains(m_jaguarCar1));
        assertTrue(set.contains(m_jaguarCar2));
    }
    public void testToPropertyValuesProperty() throws Exception {
        Set set=m_Silvester.getToPropertyValues(m_runsOver);
        assertEquals(2,set.size());
        assertTrue(set.contains(m_jaguarCar1));
        assertTrue(set.contains(m_jaguarCar2));
    }
    public void testCreateInstance() throws Exception {
        Instance jagy=m_oimodel.getInstance("test:jagy");
        assertTrue(!jagy.isInOIModel());
        assertNotInModel(jagy.getURI(),getVocabularyAdaptor().getInstanceOf(),m_jaguarCat.getURI(),false);
        applyChanges(new ChangeEvent[] { new AddEntity(jagy),new AddInstanceOf(m_jaguarCat,jagy) });
        assertInModel(jagy.getURI(),getVocabularyAdaptor().getInstanceOf(),m_jaguarCat.getURI(),false);
        assertTrue(jagy.isInOIModel());
    }
    public void testDeleteInstance() throws Exception {
        assertTrue(m_Nermal.isInOIModel());
        assertInModel(m_Nermal.getURI(),getVocabularyAdaptor().getInstanceOf(),m_persianCat.getURI(),false);
        applyChanges(new ChangeEvent[] { new RemoveInstanceOf(m_persianCat,m_Nermal),new RemoveEntity(m_Nermal) });
        assertNotInModel(m_Nermal.getURI(),getVocabularyAdaptor().getInstanceOf(),m_persianCat.getURI(),false);
        Set set=m_persianCat.getInstances();
        assertEquals(2,set.size());
        assertTrue(set.contains(m_Garfield));
        assertTrue(set.contains(m_Silvester));
        assertTrue(!m_Nermal.isInOIModel());
    }
    public void testDeleteInstanceOf() throws Exception {
        assertInModel(m_Garfield.getURI(),getVocabularyAdaptor().getInstanceOf(),m_statusSymbol.getURI(),false);
        applyChange(new RemoveInstanceOf(m_statusSymbol,m_Garfield));
        assertNotInModel(m_Garfield.getURI(),getVocabularyAdaptor().getInstanceOf(),m_statusSymbol.getURI(),false);
        assertSetEquals(m_statusSymbol.getInstances(),null);
        assertSetEquals(m_Garfield.getParentConcepts(),new Object[] { m_persianCat,m_Root });
    }
    public void testAddInstanceOf() throws Exception {
        assertNotInModel(m_Garfield.getURI(),getVocabularyAdaptor().getInstanceOf(),m_person.getURI(),false);
        applyChange(new AddInstanceOf(m_person,m_Garfield));
        assertInModel(m_Garfield.getURI(),getVocabularyAdaptor().getInstanceOf(),m_person.getURI(),false);
        assertSetEquals(m_person.getInstances(),new Object[] { m_Garfield });
        assertSetEquals(m_Garfield.getParentConcepts(),new Object[] { m_persianCat,m_statusSymbol,m_person,m_Root });
    }
    public void testAddLiteralValue() throws Exception {
        PropertyInstance propertyInstance=m_oimodel.getPropertyInstance(m_wheelsNo,m_Garfield,"4");
        assertNotInModel(m_Garfield.getURI(),m_wheelsNo.getURI(),"4",true);
        applyChange(new AddPropertyInstance(propertyInstance));
        assertInModel(m_Garfield.getURI(),m_wheelsNo.getURI(),"4",true);
        Set set=m_Garfield.getFromPropertyInstances();
        assertEquals(2,set.size());
        assertTrue(set.contains(propertyInstance));
    }
    public void testAddObjectValue() throws Exception {
        PropertyInstance propertyInstance=m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar2,m_Garfield);
        assertNotInModel(m_jaguarCar2.getURI(),m_runsOver.getURI(),m_Garfield.getURI(),false);
        applyChange(new AddPropertyInstance(propertyInstance));
        assertInModel(m_jaguarCar2.getURI(),m_runsOver.getURI(),m_Garfield.getURI(),false);
        Set set=m_jaguarCar2.getFromPropertyInstances();
        assertEquals(4,set.size());
        assertTrue(set.contains(propertyInstance));
        set=m_Garfield.getToPropertyInstances();
        assertEquals(2,set.size());
        assertTrue(set.contains(propertyInstance));
    }
    public void testRemoveLiteralValue() throws Exception {
        PropertyInstance propertyInstance=m_oimodel.getPropertyInstance(m_wheelsNo,m_jaguarCar1,"6");
        assertInModel(m_jaguarCar1.getURI(),m_wheelsNo.getURI(),"6",true);
        applyChange(new RemovePropertyInstance(propertyInstance));
        assertNotInModel(m_jaguarCar1.getURI(),m_wheelsNo.getURI(),"6",true);
        Set set=m_jaguarCar1.getFromPropertyInstances();
        assertEquals(3,set.size());
        assertTrue(!set.contains(propertyInstance));
    }
    public void testRemoveObjectValue() throws Exception {
        PropertyInstance propertyInstance=m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Silvester);
        assertInModel(m_jaguarCar1.getURI(),m_runsOver.getURI(),m_Silvester.getURI(),false);
        applyChange(new RemovePropertyInstance(propertyInstance));
        assertNotInModel(m_jaguarCar1.getURI(),m_runsOver.getURI(),m_Silvester.getURI(),false);
        Set set=m_jaguarCar1.getFromPropertyInstances();
        assertEquals(3,set.size());
        assertTrue(!set.contains(propertyInstance));
        set=m_Silvester.getToPropertyInstances();
        assertEquals(1,set.size());
        assertTrue(!set.contains(propertyInstance));
    }
    public void testSetValue() throws Exception {
        PropertyInstance propertyInstance=m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Nermal);
        SetPropertyInstanceValue event=new SetPropertyInstanceValue(propertyInstance);
        applyChange(event);
        assertNotInModel(m_jaguarCar1.getURI(),m_runsOver.getURI(),m_Silvester.getURI(),false);
        assertNotInModel(m_jaguarCar1.getURI(),m_runsOver.getURI(),m_Garfield.getURI(),false);
        assertInModel(m_jaguarCar1.getURI(),m_runsOver.getURI(),m_Nermal.getURI(),false);
        PropertyInstance removed1=m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Garfield);
        PropertyInstance removed2=m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar1,m_Silvester);
        assertEquals(2,event.getRemovedInstances().length);
        assertTrue(event.getRemovedInstances()[0].equals(removed1) || event.getRemovedInstances()[0].equals(removed2));
        assertTrue(event.getRemovedInstances()[1].equals(removed1) || event.getRemovedInstances()[1].equals(removed2));
        Set set=m_jaguarCar1.getFromPropertyInstances();
        assertEquals(3,set.size());
        assertTrue(set.contains(propertyInstance));
        assertTrue(!set.contains(removed1));
        assertTrue(!set.contains(removed2));
        set=m_Garfield.getToPropertyInstances();
        assertEquals(0,set.size());
        set=m_Silvester.getToPropertyInstances();
        assertEquals(1,set.size());
    }
    public void testPropertyInstanceIdentity() throws Exception {
        PropertyInstance instance1=null;
        Set fromJaguarCar1=m_jaguarCar1.getFromPropertyInstances();
        Iterator iterator=fromJaguarCar1.iterator();
        while (iterator.hasNext()) {
            PropertyInstance instance=(PropertyInstance)iterator.next();
            if (instance.getProperty().equals(m_runsOver) && instance.getTargetValue()==m_Silvester)
                instance1=instance;
        }
        assertNotNull(instance1);
        PropertyInstance instance2=null;
        Set toSilvester=m_Silvester.getToPropertyInstances();
        iterator=toSilvester.iterator();
        while (iterator.hasNext()) {
            PropertyInstance instance=(PropertyInstance)iterator.next();
            if (instance.getProperty().equals(m_runsOver) && instance.getSourceInstance()==m_jaguarCar1)
                instance2=instance;
        }
        assertNotNull(instance2);
        assertSame(instance1,instance2);
    }
    public void testGetAllFromPropertyValues_inverse() throws Exception {
        Set set=m_Garfield.getFromPropertyValues(m_ranOverBy);
        assertTrue(set.isEmpty());
        set=m_Garfield.getAllFromPropertyValues(m_ranOverBy);
        assertEquals(1,set.size());
        assertTrue(set.contains(m_jaguarCar1));
        set=m_Silvester.getFromPropertyValues(m_ranOverBy);
        assertTrue(set.isEmpty());
        set=m_Silvester.getAllFromPropertyValues(m_ranOverBy);
        assertEquals(2,set.size());
        assertTrue(set.contains(m_jaguarCar1));
        assertTrue(set.contains(m_jaguarCar2));
    }
    public void testPropertyInstanceInModel() throws Exception {
        PropertyInstance propertyInstance=m_oimodel.getPropertyInstance(m_runsOver,m_jaguarCar2,m_Garfield);
        assertTrue(!propertyInstance.isInOIModel());
        applyChange(new AddPropertyInstance(propertyInstance));
        assertTrue(propertyInstance.isInOIModel());
        applyChange(new RemovePropertyInstance(propertyInstance));
        assertTrue(!propertyInstance.isInOIModel());
    }
}
