package edu.unika.aifb.kaon.apionrdf.test;

import java.util.Set;
import java.util.Map;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

public class InferenceTest extends PeopleXMLTest {

    public InferenceTest(String name) {
        super(name);
    }
    public void testSymmetric() throws Exception {
        assertSetEquals(m_Dad22.getFromPropertyValues(m_friendOf),new Object[] { m_Dad21 });
        assertSetEquals(m_Dad21.getFromPropertyValues(m_friendOf),null);
        assertSetEquals(m_Dad22.getAllFromPropertyValues(m_friendOf),new Object[] { m_Dad21 });
        assertSetEquals(m_Dad21.getAllFromPropertyValues(m_friendOf),new Object[] { m_Dad22 });
    }
    public void testInverse() throws Exception {
        // properties between Grangrandad and { Grandad1, Grandad2 }
        assertSetEquals(m_Grangrandad.getFromPropertyValues(m_parentOf),new Object[] { m_Grandad1,m_Grandad2 });
        assertSetEquals(m_Grandad1.getFromPropertyValues(m_childOf),null);
        assertSetEquals(m_Grandad2.getFromPropertyValues(m_childOf),null);
        assertSetEquals(m_Grangrandad.getAllFromPropertyValues(m_parentOf),new Object[] { m_Grandad1,m_Grandad2 });
        assertSetEquals(m_Grandad1.getAllFromPropertyValues(m_childOf),new Object[] { m_Grangrandad });
        assertSetEquals(m_Grandad2.getAllFromPropertyValues(m_childOf),new Object[] { m_Grangrandad });

        // properties between Grandad1 and { Dad11 }
        assertSetEquals(m_Grandad1.getFromPropertyValues(m_parentOf),null);
        assertSetEquals(m_Dad11.getFromPropertyValues(m_childOf),new Object[] { m_Grandad1 });
        assertSetEquals(m_Grandad1.getAllFromPropertyValues(m_parentOf),new Object[] { m_Dad11 });
        assertSetEquals(m_Dad11.getAllFromPropertyValues(m_childOf),new Object[] { m_Grandad1 });

        // properties between Grandad2 and { Dad21, Dad22 }
        assertSetEquals(m_Grandad2.getFromPropertyValues(m_parentOf),new Object[] { m_Dad21 });
        assertSetEquals(m_Dad21.getFromPropertyValues(m_childOf),null);
        assertSetEquals(m_Dad22.getFromPropertyValues(m_childOf),new Object[] { m_Grandad2 });
        assertSetEquals(m_Grandad2.getAllFromPropertyValues(m_parentOf),new Object[] { m_Dad21,m_Dad22 });
        assertSetEquals(m_Dad21.getAllFromPropertyValues(m_childOf),new Object[] { m_Grandad2 });
        assertSetEquals(m_Dad22.getAllFromPropertyValues(m_childOf),new Object[] { m_Grandad2 });
    }
    public void testTransitiveAndInverse() throws Exception {
        // properties between Grangrandad and { Grandad1, Grandad2 }
        assertSetEquals(m_Grangrandad.getFromPropertyValues(m_ancestorOf),new Object[] { m_Grandad1 });
        assertSetEquals(m_Grandad1.getFromPropertyValues(m_descendantOf),null);
        assertSetEquals(m_Grandad2.getFromPropertyValues(m_descendantOf),new Object[] { m_Grangrandad });
        assertSetEquals(m_Grangrandad.getAllFromPropertyValues(m_ancestorOf),new Object[] { m_Grandad1,m_Grandad2,m_Dad11,m_Dad21,m_Dad22 });
        assertSetEquals(m_Grandad1.getAllFromPropertyValues(m_descendantOf),new Object[] { m_Grangrandad });
        assertSetEquals(m_Grandad2.getAllFromPropertyValues(m_descendantOf),new Object[] { m_Grangrandad });

        // properties between Grandad1 and { Dad11 }
        assertSetEquals(m_Grandad1.getFromPropertyValues(m_ancestorOf),new Object[] { m_Dad11 });
        assertSetEquals(m_Dad11.getFromPropertyValues(m_descendantOf),null);
        assertSetEquals(m_Grandad1.getAllFromPropertyValues(m_ancestorOf),new Object[] { m_Dad11 });
        assertSetEquals(m_Dad11.getAllFromPropertyValues(m_descendantOf),new Object[] { m_Grandad1,m_Grangrandad });

        // properties between Grandad2 and { Dad21, Dad22 }
        assertSetEquals(m_Grandad2.getFromPropertyValues(m_ancestorOf),new Object[] { m_Dad21 });
        assertSetEquals(m_Dad21.getFromPropertyValues(m_descendantOf),null);
        assertSetEquals(m_Dad22.getFromPropertyValues(m_descendantOf),new Object[] { m_Grandad2 });
        assertSetEquals(m_Grandad2.getAllFromPropertyValues(m_ancestorOf),new Object[] { m_Dad21,m_Dad22 });
        assertSetEquals(m_Dad21.getAllFromPropertyValues(m_descendantOf),new Object[] { m_Grandad2,m_Grangrandad });
        assertSetEquals(m_Dad22.getAllFromPropertyValues(m_descendantOf),new Object[] { m_Grandad2,m_Grangrandad });
    }
}
