package edu.unika.aifb.kaon.apionrdf.test;

import java.util.Set;

import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

public class ConceptTest extends JaguarXMLTest {

    public ConceptTest(String name) {
        super(name);
    }
    public void testConceptIdentity() throws Exception {
        assertTrue(m_BMW==m_oimodel.getConcept("test:BMW"));
    }
    public void testSubConcepts() throws Exception {
        Set set=m_personalCar.getSubConcepts();
        assertEquals(2,set.size());
        assertTrue(set.contains(m_jaguarCar));
        assertTrue(set.contains(m_BMW));
    }
    public void testAllSubConcepts() throws Exception {
        Set set=m_car.getAllSubConcepts();
        assertEquals(5,set.size());
        assertTrue(set.contains(m_personalCar));
        assertTrue(set.contains(m_jaguarCar));
        assertTrue(set.contains(m_BMW));
        assertTrue(set.contains(m_truck));
        assertTrue(set.contains(m_MANN));
    }
    public void testSuperCconcepts() throws Exception {
        Set set=m_jaguarCar.getSuperConcepts();
        assertEquals(2,set.size());
        assertTrue(set.contains(m_personalCar));
        assertTrue(set.contains(m_statusSymbol));
    }
    public void testAllSuperCconcepts() throws Exception {
        Set set=m_jaguarCar.getAllSuperConcepts();
        assertEquals(4,set.size());
        assertTrue(set.contains(m_personalCar));
        assertTrue(set.contains(m_car));
        assertTrue(set.contains(m_statusSymbol));
        assertTrue(set.contains(m_Root));
    }
    public void testIsDirectSubconcept() throws Exception {
        assertTrue(m_personalCar.isDirectSubConceptOf(m_car));
    }
    public void testIsSubConcept() throws Exception {
        assertTrue(m_jaguarCar.isSubConceptOf(m_car));
        assertTrue(!m_jaguarCar.isDirectSubConceptOf(m_car));
    }
    public void testPropertiesFromConcept() throws Exception {
        Set set=m_car.getPropertiesFromConcept();
        assertEquals(3,set.size());
        assertTrue(set.contains(m_color));
        assertTrue(set.contains(m_wheelsNo));
        assertTrue(set.contains(m_runsOver));
        Set setAll=m_car.getAllPropertiesFromConcept();
        assertTrue(set.containsAll(setAll));
    }
    public void testAllPropertiesFromConcept() throws Exception {
        Set set=m_jaguarCar.getAllPropertiesFromConcept();
        assertEquals(4,set.size());
        assertTrue(set.contains(m_color));
        assertTrue(set.contains(m_wheelsNo));
        assertTrue(set.contains(m_runsOver));
        assertTrue(set.contains(m_friendsWithoutIt));
        Set set1=m_jaguarCar.getPropertiesFromConcept();
        assertTrue(set1.isEmpty());
    }
    public void testPropertiesToConcept() throws Exception {
        Set set=m_cat.getPropertiesToConcept();
        assertEquals(3,set.size());
        assertTrue(set.contains(m_runsOver));
        assertTrue(set.contains(m_BMWRunsOverCat));
        assertTrue(set.contains(m_owns));
        Set setAll=m_cat.getAllPropertiesToConcept();
        assertTrue(set.containsAll(setAll));
    }
    public void testAllPropertiesToConcept() throws Exception {
        Set set=m_jaguarCat.getAllPropertiesToConcept();
        assertEquals(4,set.size());
        assertTrue(set.contains(m_runsOver));
        assertTrue(set.contains(m_BMWRunsOverCat));
        assertTrue(set.contains(m_BMWRunsOverJaguar));
        assertTrue(set.contains(m_owns));
        Set set1=m_jaguarCat.getPropertiesToConcept();
        assertEquals(1,set1.size());
        assertTrue(set1.contains(m_BMWRunsOverJaguar));
    }
    public void testAddSubConcept() throws Exception {
        assertNotInModel(m_jaguarCat.getURI(),getVocabularyAdaptor().getSubClassOf(),m_statusSymbol.getURI(),false);
        applyChange(new AddSubConcept(m_statusSymbol,m_jaguarCat));
        assertInModel(m_jaguarCat.getURI(),getVocabularyAdaptor().getSubClassOf(),m_statusSymbol.getURI(),false);
        Set subconcepts=m_statusSymbol.getSubConcepts();
        assertEquals(2,subconcepts.size());
        assertTrue(subconcepts.contains(m_jaguarCar));
        assertTrue(subconcepts.contains(m_jaguarCat));
        Set superconcepts=m_jaguarCat.getSuperConcepts();
        assertEquals(2,superconcepts.size());
        assertTrue(superconcepts.contains(m_cat));
        assertTrue(superconcepts.contains(m_statusSymbol));
    }
    public void testRemoveSubConcept() throws Exception {
        assertInModel(m_jaguarCar.getURI(),getVocabularyAdaptor().getSubClassOf(),m_statusSymbol.getURI(),false);
        applyChange(new RemoveSubConcept(m_statusSymbol,m_jaguarCar));
        assertNotInModel(m_jaguarCar.getURI(),getVocabularyAdaptor().getSubClassOf(),m_statusSymbol.getURI(),false);
        Set subconcepts=m_statusSymbol.getSubConcepts();
        assertEquals(0,subconcepts.size());
        Set superconcepts=m_jaguarCar.getSuperConcepts();
        assertEquals(1,superconcepts.size());
        assertTrue(superconcepts.contains(m_personalCar));
    }
    public void testCreateConcept() throws Exception {
        Concept beetle=m_oimodel.getConcept("test:beetle");
        assertTrue(!beetle.isInOIModel());
        assertNotInModel(beetle.getURI(),getVocabularyAdaptor().getInstanceOf(),getVocabularyAdaptor().getClass_(),false);
        assertNotInModel(beetle.getURI(),getVocabularyAdaptor().getSubClassOf(),m_car.getURI(),false);
        applyChanges(new ChangeEvent[] { new AddEntity(beetle),new AddSubConcept(m_car,beetle) });
        assertInModel(beetle.getURI(),getVocabularyAdaptor().getInstanceOf(),getVocabularyAdaptor().getClass_(),false);
        assertInModel(beetle.getURI(),getVocabularyAdaptor().getSubClassOf(),m_car.getURI(),false);
        assertTrue(m_car.getSubConcepts().contains(beetle));
        assertTrue(beetle.getSuperConcepts().contains(m_car));
        assertTrue(beetle.isInOIModel());
    }
    public void testDeleteConcept() throws Exception {
        assertInModel(m_jaguarCar.getURI(),getVocabularyAdaptor().getInstanceOf(),getVocabularyAdaptor().getClass_(),false);
        assertInModel(m_jaguarCar.getURI(),getVocabularyAdaptor().getSubClassOf(),m_personalCar.getURI(),false);
        applyChanges(new ChangeEvent[] { new RemoveSubConcept(m_personalCar,m_jaguarCar),new RemoveEntity(m_jaguarCar) });
        assertNotInModel(m_jaguarCar.getURI(),getVocabularyAdaptor().getInstanceOf(),getVocabularyAdaptor().getClass_(),false);
        assertNotInModel(m_jaguarCar.getURI(),getVocabularyAdaptor().getSubClassOf(),m_personalCar.getURI(),false);
        assertTrue(!m_personalCar.getSubConcepts().contains(m_jaguarCar));
        assertTrue(!m_jaguarCar.getSuperConcepts().contains(m_personalCar));
        assertTrue(!m_jaguarCar.isInOIModel());
    }
    public void testGetAllConcepts() throws Exception {
        Set concepts=m_oimodel.getConcepts();
        assertEquals(13,concepts.size());
        assertTrue(concepts.contains(m_Root));
        assertTrue(concepts.contains(m_statusSymbol));
        assertTrue(concepts.contains(m_car));
        assertTrue(concepts.contains(m_personalCar));
        assertTrue(concepts.contains(m_jaguarCar));
        assertTrue(concepts.contains(m_BMW));
        assertTrue(concepts.contains(m_truck));
        assertTrue(concepts.contains(m_MANN));
        assertTrue(concepts.contains(m_animal));
        assertTrue(concepts.contains(m_cat));
        assertTrue(concepts.contains(m_jaguarCat));
        assertTrue(concepts.contains(m_persianCat));
        assertTrue(concepts.contains(m_person));
    }
}
