package edu.unika.aifb.kaon.apionrdf.test;

import java.util.Set;
import java.util.Iterator;

import junit.framework.TestCase;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

/**
 * Abstract class for all tests that sets up an in-memory RDF model and contains various utility methods.
 */
public abstract class BaseTest extends TestCase {
    protected static final String RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected static final String RDFS="http://www.w3.org/2000/01/rdf-schema#";
    protected static final String KAON="http://kaon.semanticweb.org/2001/11/kaon-lexical#";
    protected static final String RDF_instanceOf=RDF+"type";
    protected static final String KAON_Label=KAON+"Label";
    protected static final String EN=KAON+"en";
    protected static final String DE=KAON+"de";
    protected static final String VALUE=KAON+"value";
    protected static final String KAON_Stem=KAON+"Stem";
    protected static final String KAON_inLanguage=KAON+"inLanguage";
    protected static final String KAON_references=KAON+"references";

    public BaseTest(String name) {
        super(name);
    }
    protected void assertSetEquals(Set set,Object[] elements) {
        if (elements==null)
            assertTrue("Set should be empty",set.isEmpty());
        else {
            assertEquals("Set doesn't have the same size as the control value",elements.length,set.size());
            for (int i=0;i<elements.length;i++)
                if (!set.contains(elements[i]))
                    fail("Set doesn't contain element "+elements[i]);
        }
    }
    protected VocabularyAdaptor getVocabularyAdaptor() {
        return KAONVocabularyAdaptor.INSTANCE;
    }
    protected void assertInModel(Model model,String subject,String predicate,String object,boolean isLiteral) throws Exception {
        Resource subj=model.getNodeFactory().createResource(subject);
        Resource pred=model.getNodeFactory().createResource(predicate);
        RDFNode obj;
        if (isLiteral)
            obj=model.getNodeFactory().createLiteral(object);
        else
            obj=model.getNodeFactory().createResource(object);
        Statement statement=model.getNodeFactory().createStatement(subj,pred,obj);
        assertTrue(model.contains(statement));
    }
    protected void assertNotInModel(Model model,String subject,String predicate,String object,boolean isLiteral) throws Exception {
        Resource subj=model.getNodeFactory().createResource(subject);
        Resource pred=model.getNodeFactory().createResource(predicate);
        RDFNode obj;
        if (isLiteral)
            obj=model.getNodeFactory().createLiteral(object);
        else
            obj=model.getNodeFactory().createResource(object);
        Statement statement=model.getNodeFactory().createStatement(subj,pred,obj);
        assertTrue(!model.contains(statement));
    }
}
