package edu.unika.aifb.kaon.apionrdf.test;

import java.net.URL;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Tests based on res/ape.xml.
 */
public class ApeXMLTest extends SingleModelTest {
    protected static Model s_apeModel;
    static {
        try {
            s_apeModel=RDFManager.openModel(JaguarXMLTest.class.getResource("res/ape.xml").toString(),null);
        }
        catch (Exception e) {
            e.printStackTrace();
            s_apeModel=null;
        }
    }

    protected Concept m_Root;
    protected Concept m_foodType;
    protected Concept m_food;
    protected Concept m_species;
    protected Concept m_animal;
    protected Concept m_ape_concept;
    protected Concept m_bannana_concept;
    protected Property m_feedsOn;
    protected Property m_hasEaten;
    protected Property m_age;
    protected Instance m_ape_instance;
    protected Instance m_bannana_instance;
    protected Instance m_bannana1;
    protected Instance m_Nkima;

    public ApeXMLTest(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        super.setUp();
        m_Root=m_oimodel.getConcept(KAON+"Root");
        m_foodType=m_oimodel.getConcept("test:foodType");
        m_food=m_oimodel.getConcept("test:food");
        m_species=m_oimodel.getConcept("test:species");
        m_animal=m_oimodel.getConcept("test:animal");
        m_ape_concept=m_oimodel.getConcept("test:ape");
        m_bannana_concept=m_oimodel.getConcept("test:bannana");
        m_feedsOn=m_oimodel.getProperty("test:feedsOn");
        m_hasEaten=m_oimodel.getProperty("test:hasEaten");
        m_age=m_oimodel.getProperty("test:age");
        m_ape_instance=m_oimodel.getInstance("test:ape");
        m_bannana_instance=m_oimodel.getInstance("test:bannana");
        m_bannana1=m_oimodel.getInstance("test:bannana1");
        m_Nkima=m_oimodel.getInstance("test:Nkima");
    }
    protected Model getDefaultModel() {
        return s_apeModel;
    }
}
