package edu.unika.aifb.kaon.apionrdf.exporter;

import java.util.Iterator;
import java.io.IOException;

import edu.unika.aifb.rdf.api.util.*;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

/**
 * An exporter for writing RDFS ontologies.
 */
public class RDFSExporter extends KAONExporter {
    /**
     * Creates an instance of this class.
     */
    public RDFSExporter() {
    }
    /**
     * Overridden not to write inclusion statements.
     *
     * @param oimodel                   the OI-model
     * @throws IOException              thrown if there is an I/O error
     * @throws KAONException            thrown if there is an error accessing the OI-model
     */
    protected void writeInclusions(OIModel oimodel) throws IOException,KAONException {
    }
    /**
     * Overridden not to write model attributes.
     *
     * @param oimodel                   the OI-model
     * @throws KAONException            thrown if there is an error accessing the OI-model
     */
    protected void writeModelAttributes(OIModel oimodel) throws KAONException {
    }
    /**
     * Overridden not to write any KAON-specific stuff.
     *
     * @param property                  the property
     * @throws KAONException            thrown if there is an error
     * @throws IOException              thrown if there is an error
     */
    protected void writeKAONSpecificPropertyInformation(Property property) throws KAONException,IOException {
    }
    /**
     * Overridden to write the lexical entries.
     *
     * @param entity                    the entity
     * @throws KAONException            thrown if there is an error
     * @throws IOException              thrown if there is an error
     */
    protected void writeLexicalEntries(Entity entity) throws KAONException,IOException {
        Iterator iterator=entity.getLexicalEntries().iterator();
        while (iterator.hasNext()) {
            LexicalEntry lexicalEntry=(LexicalEntry)iterator.next();
            String typeURI=lexicalEntry.getTypeURI();
            String predicate=null;
            if (KAONVocabularyAdaptor.INSTANCE.getKAONLabel().equals(typeURI))
                predicate=RDFConstants.RDFS_LABEL;
            else if (KAONVocabularyAdaptor.INSTANCE.getDocumentation().equals(typeURI))
                predicate=RDFConstants.RDFS_COMMENT;
            if (predicate!=null) {
                String language=lexicalEntry.getInLanguage().substring(RDFConstants.KAONNS.length());
                m_rdfWriter.writeStatement(entity.getURI(),predicate,lexicalEntry.getValue(),language,null,true);
            }
        }
    }
    /**
     * Overridden to return <code>false</code>. When exporting to RDFS, the entire model is flattened.
     *
     * @return                          <code>true</code> if only elements declared in local model should be serialzied
     */
    protected boolean shouldSerializeOnlyLocalElements() {
        return false;
    }
    /**
     * Return <code>true</code> if only given entity should be serialized.
     *
     * @param entity                    the entity being serialized
     * @return                          <code>true</code> if the entity should be serialized
     * @throws KAONException            thrown if there is an error
     */
    protected boolean shouldSerializeEntity(Entity entity) throws KAONException {
        if (entity.getURI().startsWith(RDFConstants.KAONNS))
            return false;
        if (entity instanceof Instance) {
            Iterator iterator=((Instance)entity).getParentConcepts().iterator();
            while (iterator.hasNext()) {
                Concept concept=(Concept)iterator.next();
                if (!concept.getURI().equals(KAONVocabularyAdaptor.INSTANCE.getRoot()) && concept.getURI().startsWith(RDFConstants.KAONNS))
                    return false;
            }
        }
        return true;
    }
    /**
     * Returns <code>true</code> if property instance should be serialized.
     *
     * @param propertyInstance          the property instance
     * @return                          <code>true</code> if the property instance should be serialized
     * @throws KAONException            thrown if there is an error
     */
    protected boolean shouldSerializePropertyInstance(PropertyInstance propertyInstance) throws KAONException {
        return !propertyInstance.getProperty().getURI().startsWith(RDFConstants.KAONNS);
    }
}
