package edu.unika.aifb.kaon.apionrdf.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import edu.unika.aifb.rdf.api.syntax.*;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.util.*;

/**
 * An abstract exporter for wiritng OI-models.
 */
public abstract class AbstractExporter extends OIModelProcessor {
    /** The default encoding. */
    public static final String DEFAULT_ENCODING=RDFWriter.DEFAULT_ENCODING;
    /** Phase of loading objects. */
    public static final int PHASE_LOAD_OBJECTS=1;
    /** Phase of writing concepts. */
    public static final int PHASE_WRITE_CONCEPTS=2;
    /** Phase of writing properties. */
    public static final int PHASE_WRITE_PROPERTIES=3;
    /** Phase of writing instances. */
    public static final int PHASE_WRITE_INSTANCES=4;

    /**
     * Exports supplied OI-model into RDF.
     *
     * @param oimodel                   the OI-model to serialize
     * @param physicalURI               the physical URI of the exported file
     * @param outputStream              the stream where serialization is performed
     * @param encoding                  tne encoding
     * @throws IOException              thrown if there is an error
     * @throws KAONException            thrown if there is an error accessing the OI-model
     * @throws InterruptedException     thrown if the process is interrupted
     */
    public void export(OIModel oimodel,String physicalURI,OutputStream outputStream,String encoding) throws IOException,KAONException,InterruptedException {
        export(oimodel,physicalURI,new OutputStreamWriter(outputStream,encoding),encoding);
    }
    /**
     * Serializes given RDF model.
     *
     * @param oimodel                   the OI-model to serialize
     * @param physicalURI               the physical URI of the exported file
     * @param writer                    the writer where serialization is performed
     * @param encoding                  tne encoding
     * @throws IOException              thrown if there is an error
     * @throws KAONException            thrown if there is an error accessing the OI-model
     * @throws InterruptedException     thrown if the process is interrupted
     */
    public abstract void export(OIModel oimodel,String physicalURI,Writer writer,String encoding) throws IOException,KAONException,InterruptedException;
}
