/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseConnectionProperties;
import com.microsoft.jdbc.base.BaseImplDatabaseMetaData;
import com.microsoft.jdbc.base.BaseResultSetFilterDescriptor;
import com.microsoft.jdbc.base.BaseResultSetSortDescriptor;
import com.microsoft.jdbc.base.BaseTableTypes;
import com.microsoft.jdbc.base.BaseTypeInfo;
import com.microsoft.jdbc.base.BaseTypeInfos;
import com.microsoft.jdbc.sqlserver.SQLServerImplConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.microsoft.jdbc.sqlserver.tds.TDSRPCRequest;
import com.microsoft.util.UtilDebug;
import java.sql.SQLException;

public class SQLServerImplDatabaseMetaData
extends BaseImplDatabaseMetaData {
    private static String footprint = "$Revision:   1.48.1.0  $";
    BaseConnectionProperties connectionProps;
    public static final int DBMS_NAME = 1;
    public static final int DBMS_VER = 2;
    public static final int OWNER_TERM = 10;
    public static final int TABLE_TERM = 11;
    public static final int MAX_OWNER_NAME_LENGTH = 12;
    public static final int TABLE_LENGTH = 13;
    public static final int MAX_QUAL_LENGTH = 14;
    public static final int COLUMN_LENGTH = 15;
    public static final int IDENTIFIER_CASE = 16;
    public static final int TX_ISOLATION = 17;
    public static final int COLLATION_SEQ = 18;
    public static final int SAVEPOINT_SUPPORT = 19;
    public static final int MULTI_RESULT_SETS = 20;
    public static final int ACCESSIBLE_TABLES = 22;
    public static final int USERID_LENGTH = 100;
    public static final int QUALIFIER_TERM = 101;
    public static final int NAMED_TRANSACTIONS = 102;
    public static final int SPROC_AS_LANGUAGE = 103;
    public static final int ACCESSIBLE_SPROC = 104;
    public static final int MAX_INDEX_COLS = 105;
    public static final int RENAME_TABLE = 106;
    public static final int RENAME_COLUMN = 107;
    public static final int DROP_COLUMN = 108;
    public static final int INCREASE_COLUMN_LENGTH = 109;
    public static final int DDL_IN_TRANSACTION = 110;
    public static final int DESCENDING_INDEXES = 111;
    public static final int SP_RENAME = 112;
    public static final int REMOTE_SPROC = 113;
    public static final int SYS_SPROC_VERSION = 500;
    static final Integer IntegerZero = new Integer(0);
    private static final String[] typesForTDS_07000000 = new String[]{"bit", "tinyint", "tinyint identity", "image", "varbinary", "binary", "timestamp", "text", "ntext", "char", "nchar", "uniqueidentifier", "numeric", "numeric() identity", "decimal", "money", "smallmoney", "decimal() identity", "int", "int identity", "smallint", "smallint identity", "float", "real", "varchar", "nvarchar", "sysname", "datetime", "smalldatetime"};
    private static final String[] typesForTDS_07010000 = new String[]{"bit", "tinyint", "tinyint identity", "bigint", "bigint identity", "image", "varbinary", "binary", "timestamp", "text", "ntext", "char", "nchar", "uniqueidentifier", "numeric", "numeric() identity", "decimal", "money", "smallmoney", "decimal() identity", "int", "int identity", "smallint", "smallint identity", "float", "real", "varchar", "nvarchar", "sysname", "sql_variant", "datetime", "smalldatetime"};

    public SQLServerImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        this.connectionProps = baseConnectionProperties;
    }

    private String formatCatalogQualifier(String string) {
        String string2 = string;
        string2 = string2 != null ? String.valueOf(string2) + ".." : "";
        return string2;
    }

    public String getResultSetSQL(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        String string = null;
        String string2 = ", ";
        switch (n) {
            case 1: {
                String string3 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string4 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string5 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String[] stringArray = (String[])baseResultSetFilterDescriptor.getRestriction(4);
                string = String.valueOf(this.formatCatalogQualifier(string3)) + "sp_tables " + this.valueOfDatabaseMetaDataParam(string5, true) + string2 + this.valueOfDatabaseMetaDataParam(string4, true) + string2 + this.valueOfDatabaseMetaDataParam(string3, false) + string2;
                if (stringArray == null) {
                    string = String.valueOf(string) + "null";
                    break;
                }
                string = String.valueOf(string) + "\"";
                int n2 = 0;
                while (n2 < stringArray.length) {
                    string = String.valueOf(string) + "'" + stringArray[n2] + "'";
                    if (n2 != stringArray.length - 1) {
                        string = String.valueOf(string) + ",";
                    }
                    ++n2;
                }
                string = String.valueOf(string) + "\"";
                break;
            }
            case 2: {
                String string6 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string7 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string8 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string9 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                string = String.valueOf(this.formatCatalogQualifier(string6)) + "sp_columns " + this.valueOfDatabaseMetaDataParam(string8, true) + string2 + this.valueOfDatabaseMetaDataParam(string7, true) + string2 + this.valueOfDatabaseMetaDataParam(string6, false) + string2 + this.valueOfDatabaseMetaDataParam(string9, true) + string2 + "@ODBCVer = 3";
                break;
            }
            case 5: {
                String string10 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string11 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string12 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string = String.valueOf(this.formatCatalogQualifier(string10)) + "sp_stored_procedures " + this.valueOfDatabaseMetaDataParam(string12, true) + string2 + this.valueOfDatabaseMetaDataParam(string11, true) + string2 + this.valueOfDatabaseMetaDataParam(string10, false);
                break;
            }
            case 6: {
                String string13 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string14 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string15 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string16 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                string = String.valueOf(this.formatCatalogQualifier(string13)) + "sp_sproc_columns " + this.valueOfDatabaseMetaDataParam(string15, true) + string2 + this.valueOfDatabaseMetaDataParam(string14, true) + string2 + this.valueOfDatabaseMetaDataParam(string13, false) + string2 + this.valueOfDatabaseMetaDataParam(string16, true) + string2 + "@ODBCVer = 3";
                break;
            }
            case 16: {
                String string17 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string18 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string19 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string = String.valueOf(this.formatCatalogQualifier(string17)) + "sp_table_privileges " + this.valueOfDatabaseMetaDataParam(string19, true) + string2 + this.valueOfDatabaseMetaDataParam(string18, true) + string2 + this.valueOfDatabaseMetaDataParam(string17, false);
                break;
            }
            case 9: {
                String string20 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string21 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string22 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string23 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                string = String.valueOf(this.formatCatalogQualifier(string20)) + "sp_column_privileges " + this.valueOfDatabaseMetaDataParam(string22, false) + string2 + this.valueOfDatabaseMetaDataParam(string21, false) + string2 + this.valueOfDatabaseMetaDataParam(string20, false) + string2 + this.valueOfDatabaseMetaDataParam(string23, true);
                break;
            }
            case 14: {
                String string24 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string25 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string26 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string = String.valueOf(this.formatCatalogQualifier(string24)) + "sp_pkeys " + this.valueOfDatabaseMetaDataParam(string26, false) + string2 + this.valueOfDatabaseMetaDataParam(string25, false) + string2 + this.valueOfDatabaseMetaDataParam(string24, false);
                break;
            }
            case 11: {
                String string27 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string28 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string29 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string = String.valueOf(this.formatCatalogQualifier(string27)) + "sp_fkeys " + this.valueOfDatabaseMetaDataParam(string29, false) + string2 + this.valueOfDatabaseMetaDataParam(string28, false) + string2 + this.valueOfDatabaseMetaDataParam(string27, false) + string2 + "null, null, null";
                break;
            }
            case 12: {
                String string30 = (String)baseResultSetFilterDescriptor.getRestriction(5);
                String string31 = (String)baseResultSetFilterDescriptor.getRestriction(6);
                String string32 = (String)baseResultSetFilterDescriptor.getRestriction(7);
                string = String.valueOf(this.formatCatalogQualifier(string30)) + "sp_fkeys null, null, null, " + this.valueOfDatabaseMetaDataParam(string32, false) + string2 + this.valueOfDatabaseMetaDataParam(string31, false) + string2 + this.valueOfDatabaseMetaDataParam(string30, false);
                break;
            }
            case 10: {
                String string33 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string34 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string35 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string36 = (String)baseResultSetFilterDescriptor.getRestriction(5);
                String string37 = (String)baseResultSetFilterDescriptor.getRestriction(6);
                String string38 = (String)baseResultSetFilterDescriptor.getRestriction(7);
                string = String.valueOf(this.formatCatalogQualifier(string33)) + "sp_fkeys " + this.valueOfDatabaseMetaDataParam(string35, false) + string2 + this.valueOfDatabaseMetaDataParam(string34, false) + string2 + this.valueOfDatabaseMetaDataParam(string33, false) + string2 + this.valueOfDatabaseMetaDataParam(string38, false) + string2 + this.valueOfDatabaseMetaDataParam(string37, false) + string2 + this.valueOfDatabaseMetaDataParam(string36, false);
                break;
            }
            case 13: {
                String string39 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string40 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string41 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                Boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
                Boolean bl2 = (Boolean)baseResultSetFilterDescriptor.getRestriction(14);
                string = String.valueOf(this.formatCatalogQualifier(string39)) + "sp_statistics " + this.valueOfDatabaseMetaDataParam(string41, false) + string2 + this.valueOfDatabaseMetaDataParam(string40, false) + string2 + this.valueOfDatabaseMetaDataParam(string39, false) + string2 + this.valueOfDatabaseMetaDataParam("%", false) + string2 + this.valueOfDatabaseMetaDataParam(bl != false ? "Y" : "N", false) + string2 + this.valueOfDatabaseMetaDataParam(bl2 != false ? "Q" : "E", false);
                break;
            }
            case 7: {
                String string42 = (String)baseResultSetFilterDescriptor.getRestriction(9);
                String string43 = (String)baseResultSetFilterDescriptor.getRestriction(10);
                String string44 = (String)baseResultSetFilterDescriptor.getRestriction(11);
                Integer n3 = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
                Boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
                string = String.valueOf(this.formatCatalogQualifier(string42)) + "sp_special_columns " + this.valueOfDatabaseMetaDataParam(string44, false) + string2 + this.valueOfDatabaseMetaDataParam(string43, false) + string2 + this.valueOfDatabaseMetaDataParam(string42, false) + string2 + this.valueOfDatabaseMetaDataParam("R", false) + string2;
                if (n3 == null) {
                    string = String.valueOf(string) + this.valueOfDatabaseMetaDataParam("C", false) + string2;
                } else if (n3 == 0) {
                    string = String.valueOf(string) + this.valueOfDatabaseMetaDataParam("C", false) + string2;
                } else if (n3 == 1) {
                    string = String.valueOf(string) + this.valueOfDatabaseMetaDataParam("T", false) + string2;
                } else if (n3 == 2) {
                    string = String.valueOf(string) + this.valueOfDatabaseMetaDataParam("S", false) + string2;
                }
                string = bl != null && bl != false ? String.valueOf(string) + this.valueOfDatabaseMetaDataParam("U", false) + string2 : String.valueOf(string) + this.valueOfDatabaseMetaDataParam("O", false) + string2;
                string = String.valueOf(string) + "@ODBCVer = 3";
                break;
            }
            case 18: {
                String string45 = (String)baseResultSetFilterDescriptor.getRestriction(9);
                String string46 = (String)baseResultSetFilterDescriptor.getRestriction(10);
                String string47 = (String)baseResultSetFilterDescriptor.getRestriction(11);
                string = String.valueOf(this.formatCatalogQualifier(string45)) + "sp_special_columns " + this.valueOfDatabaseMetaDataParam(string47, false) + string2 + this.valueOfDatabaseMetaDataParam(string46, false) + string2 + this.valueOfDatabaseMetaDataParam(string45, false) + string2 + this.valueOfDatabaseMetaDataParam("V", false) + string2 + "@ODBCVer = 3";
                break;
            }
            case 15: {
                string = "select name from sysusers where islogin=1";
                break;
            }
            case 8: {
                string = "sp_tables '', '', '%'";
                break;
            }
        }
        if (baseResultSetFilterDescriptor != null) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
        }
        return string;
    }

    public BaseTableTypes getTableTypes() {
        BaseTableTypes baseTableTypes = new BaseTableTypes();
        baseTableTypes.add("SYSTEM TABLE");
        baseTableTypes.add("TABLE");
        baseTableTypes.add("VIEW");
        return baseTableTypes;
    }

    public BaseTypeInfos getTypeInfo() throws SQLException {
        BaseTypeInfos baseTypeInfos;
        SQLServerImplConnection sQLServerImplConnection = (SQLServerImplConnection)this.getImplConnection();
        try {
            String[] stringArray = sQLServerImplConnection.conn.getTDSVersion() == 1 ? typesForTDS_07000000 : typesForTDS_07010000;
            BaseTypeInfos baseTypeInfos2 = new BaseTypeInfos();
            TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(sQLServerImplConnection.conn, sQLServerImplConnection.reader, sQLServerImplConnection.writer, "sp_datatype_info @ODBCVer=3", true);
            tDSExecuteRequest.submitRequest();
            tDSExecuteRequest.processReply(null);
            while (tDSExecuteRequest.getRow(null)) {
                tDSExecuteRequest.getColumnDataForRow(18, 1019);
                String string = (String)tDSExecuteRequest.getColumn(1).getData();
                if (this.isUserDefinedType(stringArray, string)) continue;
                BaseTypeInfo baseTypeInfo = new BaseTypeInfo();
                baseTypeInfo.typeName = string;
                short s = ((Integer)tDSExecuteRequest.getColumn(2).getData()).shortValue();
                s = SQLServerImplDatabaseMetaData.mapODBCTypeToJDBCType(s);
                baseTypeInfo.dataType = new Short(s);
                baseTypeInfo.maxPrecision = (Integer)tDSExecuteRequest.getColumn(3).getData();
                baseTypeInfo.literalPrefix = (String)tDSExecuteRequest.getColumn(4).getData();
                baseTypeInfo.literalSuffix = (String)tDSExecuteRequest.getColumn(5).getData();
                baseTypeInfo.createParams = (String)tDSExecuteRequest.getColumn(6).getData();
                Object object = tDSExecuteRequest.getColumn(7).getData();
                baseTypeInfo.nullable = new Short(((Integer)object).shortValue());
                object = tDSExecuteRequest.getColumn(8).getData();
                baseTypeInfo.caseSensitive = object == null ? null : ((Integer)object == 0 ? new Boolean(false) : new Boolean(true));
                object = tDSExecuteRequest.getColumn(9).getData();
                baseTypeInfo.searchable = new Short(((Integer)object).shortValue());
                object = tDSExecuteRequest.getColumn(10).getData();
                baseTypeInfo.unsignedAttribute = object == null ? null : ((Integer)object == 0 ? new Boolean(false) : new Boolean(true));
                object = tDSExecuteRequest.getColumn(11).getData();
                baseTypeInfo.fixedPrecScale = object == null ? null : ((Integer)object == 0 ? new Boolean(false) : new Boolean(true));
                object = tDSExecuteRequest.getColumn(12).getData();
                baseTypeInfo.autoIncrement = object == null ? null : ((Integer)object == 0 ? new Boolean(false) : new Boolean(true));
                baseTypeInfo.localTypeName = (String)tDSExecuteRequest.getColumn(13).getData();
                object = tDSExecuteRequest.getColumn(14).getData();
                baseTypeInfo.minimumScale = object == null ? null : new Short(((Integer)object).shortValue());
                object = tDSExecuteRequest.getColumn(15).getData();
                baseTypeInfo.maximumScale = object == null ? null : new Short(((Integer)object).shortValue());
                baseTypeInfo.numPrecRadix = (Integer)tDSExecuteRequest.getColumn(18).getData();
                baseTypeInfos2.add(baseTypeInfo);
            }
            tDSExecuteRequest.discardReplyBytes();
            this.sortTypeInfo(stringArray, baseTypeInfos2);
            baseTypeInfos = baseTypeInfos2;
            Object var4_10 = null;
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            sQLServerImplConnection.removeReference();
            throw throwable;
        }
        sQLServerImplConnection.removeReference();
        return baseTypeInfos;
    }

    public void initializeNonResultSetMetaData(int n) throws SQLException {
        if (n == 101) {
            return;
        }
        this.processServerInfo();
    }

    private boolean isUserDefinedType(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static short mapODBCTypeToJDBCType(short s) {
        switch (s) {
            case -150: {
                s = (short)12;
                break;
            }
            case -11: {
                s = 1;
                break;
            }
            case -10: {
                s = (short)-1;
                break;
            }
            case -9: {
                s = (short)12;
                break;
            }
            case -8: {
                s = 1;
                break;
            }
            case 0: 
            case 8: 
            case 91: 
            case 92: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                UtilDebug.assert((String)"Unexpected support for JDBC data type.", (boolean)false);
                break;
            }
            default: {
                s = (short)1111;
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 93: 
        }
        return s;
    }

    void processServerInfo() throws SQLException {
        SQLServerImplConnection sQLServerImplConnection = (SQLServerImplConnection)this.getImplConnection();
        try {
            TDSRPCRequest tDSRPCRequest = new TDSRPCRequest(sQLServerImplConnection.conn, sQLServerImplConnection.reader, sQLServerImplConnection.writer, "sp_server_info");
            tDSRPCRequest.submitRequest();
            tDSRPCRequest.processReply(null);
            while (tDSRPCRequest.getRow(null)) {
                tDSRPCRequest.getColumnDataForRow(3, 1019);
                Integer n = (Integer)tDSRPCRequest.getColumn(1).getData();
                String string = (String)tDSRPCRequest.getColumn(3).getData();
                switch (n) {
                    case 1: {
                        this.databaseProductName = string;
                        break;
                    }
                    case 2: {
                        this.databaseProductVersion = string;
                        break;
                    }
                    case 10: {
                        this.schemaTerm = string;
                        break;
                    }
                    case 12: {
                        this.maxSchemaNameLength = new Integer(string);
                        break;
                    }
                    case 13: {
                        this.maxTableNameLength = new Integer(string);
                        break;
                    }
                    case 14: {
                        this.maxCatalogNameLength = new Integer(string);
                        break;
                    }
                    case 15: {
                        this.maxColumnNameLength = new Integer(string);
                        break;
                    }
                    case 16: {
                        if (string.compareTo("MIXED") == 0) {
                            this.storesMixedCaseIdentifiers = new Boolean(true);
                            this.supportsMixedCaseIdentifiers = new Boolean(false);
                            this.storesMixedCaseQuotedIdentifiers = new Boolean(true);
                            this.supportsMixedCaseQuotedIdentifiers = new Boolean(false);
                            break;
                        }
                        if (string.compareTo("SENSITIVE") != 0) break;
                        this.storesMixedCaseIdentifiers = new Boolean(false);
                        this.supportsMixedCaseIdentifiers = new Boolean(true);
                        this.storesMixedCaseQuotedIdentifiers = new Boolean(false);
                        this.supportsMixedCaseQuotedIdentifiers = new Boolean(true);
                        break;
                    }
                    case 20: {
                        if (string.compareTo("Y") == 0) {
                            this.supportsMultipleResultSets = new Boolean(true);
                            break;
                        }
                        this.supportsMultipleResultSets = new Boolean(false);
                        break;
                    }
                    case 101: {
                        this.catalogTerm = string;
                        break;
                    }
                    case 105: {
                        this.maxColumnsInIndex = new Integer(string);
                        break;
                    }
                    case 17: {
                        this.defaultTransactionIsolation = new Integer(string);
                        break;
                    }
                    case 22: {
                        if (string.compareTo("Y") == 0) {
                            this.allTablesAreSelectable = new Boolean(true);
                            break;
                        }
                        this.allTablesAreSelectable = new Boolean(false);
                        break;
                    }
                    case 100: {
                        this.maxUserNameLength = new Integer(string);
                        break;
                    }
                    case 104: {
                        if (string.compareTo("Y") == 0) {
                            this.allProceduresAreCallable = new Boolean(true);
                            break;
                        }
                        this.allProceduresAreCallable = new Boolean(false);
                        break;
                    }
                    case 108: {
                        if (string.compareTo("Y") == 0) {
                            this.supportsAlterTableWithDropColumn = new Boolean(true);
                            break;
                        }
                        this.supportsAlterTableWithDropColumn = new Boolean(false);
                        break;
                    }
                    case 110: {
                        if (string.compareTo("Y") == 0) {
                            this.supportsDataDefinitionAndDataManipulationTransactions = new Boolean(true);
                            this.supportsDataManipulationTransactionsOnly = new Boolean(false);
                            break;
                        }
                        this.supportsDataDefinitionAndDataManipulationTransactions = new Boolean(false);
                        this.supportsDataManipulationTransactionsOnly = new Boolean(true);
                        break;
                    }
                }
            }
            tDSRPCRequest.discardReplyBytes();
        }
        finally {
            Object var3_5 = null;
            sQLServerImplConnection.removeReference();
        }
    }

    public void setup(BaseConnection baseConnection) throws SQLException {
        super.setup(baseConnection);
        this.isReadOnly = new Boolean(false);
        this.nullsAreSortedHigh = new Boolean(false);
        this.nullsAreSortedLow = new Boolean(true);
        this.nullsAreSortedAtStart = new Boolean(false);
        this.nullsAreSortedAtEnd = new Boolean(false);
        this.nullPlusNonNullIsNull = new Boolean(true);
        this.storesUpperCaseIdentifiers = new Boolean(false);
        this.storesLowerCaseIdentifiers = new Boolean(false);
        this.storesUpperCaseQuotedIdentifiers = new Boolean(false);
        this.storesLowerCaseQuotedIdentifiers = new Boolean(false);
        this.identifierQuoteString = new String("\"");
        this.SQLKeywords = new String("arith_overflow,break,browse,bulk,char_convert,checkpoint,clustered,commit,compute,confirm,controlrow,data_pgs,database,dbcc,disk,dummy,dump,endtran,errlvl,errorexit,exit,fillfactor,holdlock,identity_insert,if,kill,lineno,load,mirror,mirrorexit,noholdlock,nonclustered,numeric_truncation,offsets,once,over,perm,permanent,plan,print,proc,processexit,raiserror,read,readtext,reconfigure,replace,reserved_pgs,return,role,rowcnt,rowcount,rule,save,setuser,shared,shutdown,some,statistics,stripe,syb_identity,syb_restree,syb_terminate,temp,textsize,tran,trigger,truncate,tsequal,used_pgs,user_option,waitfor,while,writetext");
        this.numericFunctions = new String("abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign,sin,sqrt,tan");
        this.stringFunctions = new String("ascii,concat,difference,left,length,lcase,ltrim,repeat,right,rtrim,soundex,space,substring,ucase,char");
        this.systemFunctions = new String("dbname,ifnull,username");
        this.timeDateFunctions = new String("dayname,dayofmonth,dayofweek,dayofyearhour,minute,month,monthname,now,quarter,timestampadd,timestampdiffsecond,week,year");
        this.searchStringEscape = new String("\\");
        this.supportsAlterTableWithAddColumn = new Boolean(true);
        this.supportsColumnAliasing = new Boolean(true);
        this.supportsTableCorrelationNames = new Boolean(true);
        this.supportsDifferentTableCorrelationNames = new Boolean(false);
        this.supportsExpressionsInOrderBy = new Boolean(true);
        this.supportsOrderByUnrelated = new Boolean(true);
        this.supportsGroupBy = new Boolean(true);
        this.supportsGroupByUnrelated = new Boolean(true);
        this.supportsGroupByBeyondSelect = new Boolean(true);
        this.supportsLikeEscapeClause = new Boolean(false);
        this.supportsMultipleTransactions = new Boolean(true);
        this.supportsTransactionIsolationLevelReadCommited = new Boolean(true);
        this.supportsTransactionIsolationLevelReadUncommited = new Boolean(true);
        this.supportsTransactionIsolationLevelRepeatableRead = new Boolean(true);
        this.supportsTransactionIsolationLevelSerializable = new Boolean(true);
        this.supportsNonNullableColumns = new Boolean(true);
        this.supportsMinimumSQLGrammar = new Boolean(true);
        this.supportsCoreSQLGrammar = new Boolean(true);
        this.supportsExtendedSQLGrammar = new Boolean(false);
        this.supportsANSI92EntryLevelSQL = new Boolean(true);
        this.supportsANSI92IntermediateSQL = new Boolean(false);
        this.supportsANSI92FullSQL = new Boolean(false);
        this.supportsOuterJoins = new Boolean(true);
        this.supportsFullOuterJoins = new Boolean(false);
        this.supportsLimitedOuterJoins = new Boolean(true);
        this.procedureTerm = new String("stored procedure");
        this.isCatalogAtStart = new Boolean(true);
        this.catalogSeparator = new String(".");
        this.supportsSchemasInDataManipulation = new Boolean(true);
        this.supportsSchemasInProcedureCalls = new Boolean(true);
        this.supportsSchemasInTableDefinitions = new Boolean(true);
        this.supportsSchemasInIndexDefinitions = new Boolean(true);
        this.supportsSchemasInPrivilegeDefinitions = new Boolean(true);
        this.supportsCatalogsInDataManipulation = new Boolean(true);
        this.supportsCatalogsInProcedureCalls = new Boolean(true);
        this.supportsCatalogsInTableDefinitions = new Boolean(true);
        this.supportsCatalogsInIndexDefinitions = new Boolean(true);
        this.supportsCatalogsInPrivilegeDefinitions = new Boolean(false);
        this.supportsPositionedDelete = new Boolean(false);
        this.supportsPositionedUpdate = new Boolean(false);
        this.supportsSelectForUpdate = new Boolean(false);
        this.supportsStoredProcedures = new Boolean(true);
        this.supportsSubqueriesInComparisons = new Boolean(true);
        this.supportsSubqueriesInExists = new Boolean(true);
        this.supportsSubqueriesInIns = new Boolean(true);
        this.supportsSubqueriesInQuantifieds = new Boolean(true);
        this.supportsCorrelatedSubqueries = new Boolean(true);
        this.supportsUnion = new Boolean(true);
        this.supportsUnionAll = new Boolean(true);
        this.supportsOpenCursorsAcrossCommit = new Boolean(false);
        this.supportsOpenCursorsAcrossRollback = new Boolean(false);
        this.maxBinaryLiteralLength = IntegerZero;
        this.maxCharLiteralLength = IntegerZero;
        this.maxColumnsInGroupBy = new Integer(16);
        this.maxColumnsInOrderBy = new Integer(16);
        this.maxColumnsInSelect = new Integer(4096);
        this.maxColumnsInTable = new Integer(1024);
        this.maxConnections = IntegerZero;
        this.extraNameCharacters = new String("$#@");
        this.maxProcedureNameLength = new Integer(128);
        this.maxCursorNameLength = new Integer(128);
        this.maxStatementLength = IntegerZero;
        this.maxIndexLength = new Integer(900);
        this.maxStatements = this.connectionProps.get("selectMethod").equalsIgnoreCase("cursor") ? IntegerZero : new Integer(1);
        this.maxTablesInSelect = new Integer(32);
        this.supportsTransactions = new Boolean(true);
        this.supportsResultSetTypeScrollInsensitive = new Boolean(true);
        this.ownUpdatesAreVisibleScrollInsensitive = new Boolean(false);
        this.ownDeletesAreVisibleScrollInsensitive = new Boolean(false);
        this.ownInsertsAreVisibleScrollInsensitive = new Boolean(false);
        this.othersUpdatesAreVisibleScrollInsensitive = new Boolean(false);
        this.othersDeletesAreVisibleScrollInsensitive = new Boolean(false);
        this.othersInsertsAreVisibleScrollInsensitive = new Boolean(false);
        this.updatesAreDetectedScrollInsensitive = new Boolean(false);
        this.deletesAreDetectedScrollInsensitive = new Boolean(false);
        this.insertsAreDetectedScrollInsensitive = new Boolean(false);
        this.supportsResultSetTypeScrollSensitive = new Boolean(false);
        this.ownUpdatesAreVisibleScrollSensitive = new Boolean(false);
        this.ownDeletesAreVisibleScrollSensitive = new Boolean(false);
        this.ownInsertsAreVisibleScrollSensitive = new Boolean(false);
        this.othersUpdatesAreVisibleScrollSensitive = new Boolean(false);
        this.othersDeletesAreVisibleScrollSensitive = new Boolean(false);
        this.othersInsertsAreVisibleScrollSensitive = new Boolean(false);
        this.updatesAreDetectedScrollSensitive = new Boolean(false);
        this.deletesAreDetectedScrollSensitive = new Boolean(false);
        this.insertsAreDetectedScrollSensitive = new Boolean(false);
        this.ownUpdatesAreVisibleForwardOnly = new Boolean(false);
        this.ownDeletesAreVisibleForwardOnly = new Boolean(false);
        this.ownInsertsAreVisibleForwardOnly = new Boolean(false);
        this.othersUpdatesAreVisibleForwardOnly = new Boolean(false);
        this.othersDeletesAreVisibleForwardOnly = new Boolean(false);
        this.othersInsertsAreVisibleForwardOnly = new Boolean(false);
        this.updatesAreDetectedForwardOnly = new Boolean(false);
        this.deletesAreDetectedForwardOnly = new Boolean(false);
        this.insertsAreDetectedForwardOnly = new Boolean(false);
        this.supportsBatchUpdates = new Boolean(true);
        this.usesLocalFiles = new Boolean(false);
        this.usesLocalFilePerTable = new Boolean(false);
        this.supportsIntegrityEnhancementFacility = new Boolean(false);
        this.supportsOpenStatementsAcrossCommit = new Boolean(true);
        this.supportsOpenStatementsAcrossRollback = new Boolean(true);
        this.dataDefinitionCausesTransactionCommit = new Boolean(false);
        this.dataDefinitionIgnoredInTransactions = new Boolean(false);
        this.doesMaxRowSizeIncludeBlobs = new Boolean(false);
        this.maxRowSize = new Integer(8060);
        this.supportsConvert = new Boolean(true);
    }

    private void sortTypeInfo(String[] stringArray, BaseTypeInfos baseTypeInfos) {
        int n = baseTypeInfos.count();
        UtilDebug.assert((String)"Unexpected type info obtained from the server.", (n == stringArray.length ? 1 : 0) != 0);
        int n2 = 0;
        while (n2 < n) {
            boolean bl = true;
            if (!bl) break;
            bl = false;
            int n3 = n2;
            while (n3 < n) {
                Object object = baseTypeInfos.get(n3);
                if (stringArray[n2].equals(object.typeName) && n2 != n3) {
                    object = baseTypeInfos.set(n2, object);
                    baseTypeInfos.set(n3, object);
                    bl = true;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        if (n == n2) {
            return true;
        }
        switch (n) {
            case -3: 
            case -2: {
                if (n2 != 6 && n2 != 7 && n2 != -1) break;
                return false;
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 91: 
            case 92: 
            case 93: {
                if (n2 != -4 && n2 != -1) break;
                return false;
            }
            case -1: {
                if (n2 == 1 || n2 == 12) break;
                return false;
            }
            case -4: {
                if (n2 == -2 || n2 == -3) break;
                return false;
            }
            case 8: 
            case 1111: {
                return false;
            }
        }
        return true;
    }

    private String valueOfDatabaseMetaDataParam(String string, boolean bl) {
        String string2;
        if (string == null) {
            return "null";
        }
        if (bl) {
            string2 = new String();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c == '\\' && n2 != n - 1) {
                    char c2 = string.charAt(n2 + 1);
                    string2 = c2 == '_' || c2 == '%' ? String.valueOf(string2) + "[" + c2 + "]" : String.valueOf(string2) + (c + c2);
                    ++n2;
                } else {
                    string2 = String.valueOf(string2) + c;
                }
                ++n2;
            }
        } else {
            string2 = string;
        }
        return "'" + string2 + "'";
    }
}

