/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbcx.base;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbcx.base.BaseImplXAResource;
import com.microsoft.jdbcx.base.BasePooledConnection;
import com.microsoft.jdbcx.base.BaseXADataSource;
import com.microsoft.jdbcx.base.BaseXAResource;
import java.sql.SQLException;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class BaseXAConnection
extends BasePooledConnection
implements XAConnection {
    private static String footprint = "$Revision:   1.4.1.0  $";
    private BaseXADataSource xaDataSource;
    private BaseXAResource xaResource;
    protected BaseImplXAResource implXAResource;
    private boolean inGlobalTransaction;

    public BaseXAConnection(BaseXADataSource baseXADataSource, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        super(baseConnection, baseExceptions);
        this.xaDataSource = baseXADataSource;
        this.xaResource = null;
        this.implXAResource = null;
        this.inGlobalTransaction = false;
        try {
            this.implXAResource = baseXADataSource.createImplXAResource(baseConnection);
            this.implXAResource.open();
        }
        catch (SQLException sQLException) {
            baseConnection.close();
            throw sQLException;
        }
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.implXAResource.close();
        }
        catch (Throwable throwable) {}
        this.realConnection.closeXA(this.inGlobalTransaction);
    }

    public synchronized void commit() throws SQLException {
        if (this.inGlobalTransaction) {
            throw this.exceptions.getException(6074);
        }
        super.commit();
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        if (this.inGlobalTransaction) {
            return false;
        }
        return super.getAutoCommit();
    }

    public synchronized XAResource getXAResource() throws SQLException {
        if (this.isClosed()) {
            throw this.exceptions.getException(6010);
        }
        if (this.xaResource == null) {
            this.xaResource = new BaseXAResource(this, this.implXAResource);
        }
        return this.xaResource;
    }

    public void reset(List list, List list2) {
        try {
            try {
                BaseConnection baseConnection = this.realConnection;
                synchronized (baseConnection) {
                    this.commonReset(list, list2);
                    this.realConnection.resetXA(this.inGlobalTransaction);
                    this.implXAResource.reset();
                }
                this.connectionClosed();
            }
            catch (SQLException sQLException) {
                this.connectionErrorOccurred(sQLException);
            }
            Object var4_5 = null;
            this.pooledConnectionBusy = false;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.pooledConnectionBusy = false;
            throw throwable;
        }
    }

    public synchronized void rollback() throws SQLException {
        if (this.inGlobalTransaction) {
            throw this.exceptions.getException(6075);
        }
        super.rollback();
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.inGlobalTransaction) {
            if (!bl) {
                return;
            }
            throw this.exceptions.getException(6073);
        }
        super.setAutoCommit(bl);
    }

    synchronized void setGlobalTransaction(boolean bl) {
        this.inGlobalTransaction = bl;
    }
}

