/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import xdoclet.DocletContext;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.template.TemplateException;
import xdoclet.util.Translator;

public class PackageTagsHandler
extends AbstractProgramElementTagsHandler {
    public static String getPackageNameFor(PackageDoc pak) {
        return PackageTagsHandler.getPackageNameFor(pak.name());
    }

    public static String getPackageNameFor(String packageName) {
        Vector package_substitutions = PackageTagsHandler.getPackageSubstitutions(DocletContext.getInstance().getActiveSubTask().getSubTaskName());
        if (package_substitutions == null) {
            return packageName;
        }
        int i = 0;
        while (i < package_substitutions.size()) {
            PackageSubstitution ps = (PackageSubstitution)package_substitutions.elementAt(i);
            StringTokenizer st = new StringTokenizer(ps.getPackages(), ",", false);
            while (st.hasMoreTokens()) {
                String packages = st.nextToken();
                String suffix = "." + packages;
                if (!packageName.endsWith(suffix)) continue;
                packageName = packageName.substring(0, packageName.length() - suffix.length()) + "." + ps.getSubstituteWith();
                break;
            }
            ++i;
        }
        return packageName;
    }

    public static Vector getPackageSubstitutions(String subtask_name) {
        Vector package_substitutions = null;
        boolean supports_package_substitution_inheritance = true;
        Boolean supports = (Boolean)DocletContext.getInstance().getConfigParam(subtask_name + ".packageSubstitutionInheritanceSupported");
        if (supports != null) {
            supports_package_substitution_inheritance = supports;
        }
        package_substitutions = (Vector)DocletContext.getInstance().getConfigParam(subtask_name + ".packageSubstitutions");
        if (supports_package_substitution_inheritance && (package_substitutions == null || package_substitutions.isEmpty())) {
            package_substitutions = (Vector)DocletContext.getInstance().getConfigParam("packageSubstitutions");
        }
        return package_substitutions;
    }

    public static String packageNameAsPathFor(PackageDoc pak) {
        return PackageTagsHandler.getPackageNameFor(pak).replace('.', '/');
    }

    public static String packageNameAsPathFor(String qualified_name) {
        return qualified_name.replace('.', '/');
    }

    public String packageName() throws XDocletException {
        if (XDocletTagSupport.getCurrentPackage() != null) {
            return XDocletTagSupport.getCurrentPackage().name();
        }
        return XDocletTagSupport.getCurrentClass().containingPackage().name();
    }

    public void packageOf(String template) throws XDocletException {
        try {
            String fullClassName = this.getEngine().outputOf(template);
            this.getEngine().print(PackageTagsHandler.getPackageNameFor(fullClassName.substring(0, fullClassName.lastIndexOf("."))));
        }
        catch (TemplateException ex) {
            throw new XDocletException(ex, Translator.getString("method_failed", new String[]{"packageOf"}));
        }
    }

    public void forAllPackages(String template, Properties attributes) throws XDocletException {
        ClassDoc[] classes = XDocletTagSupport.getDocletContext().getRoot().classes();
        TreeSet<PackageDoc> packages = new TreeSet<PackageDoc>();
        int i = 0;
        while (i < classes.length) {
            packages.add(classes[i].containingPackage());
            ++i;
        }
        PackageDoc cur_package = null;
        Iterator packageIterator = packages.iterator();
        while (packageIterator.hasNext()) {
            cur_package = (PackageDoc)packageIterator.next();
            XDocletTagSupport.setCurrentPackage(cur_package);
            this.generate(template);
        }
        XDocletTagSupport.setCurrentPackage(null);
    }

    public String packageNameAsPath() throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor(this.packageName());
    }

    public static class PackageSubstitution
    implements Serializable {
        private String packages = null;
        private String substituteWith = null;

        public String getPackages() {
            return this.packages;
        }

        public String getSubstituteWith() {
            return this.substituteWith;
        }

        public void setPackages(String packages) {
            this.packages = packages;
        }

        public void setSubstituteWith(String substituteWith) {
            this.substituteWith = substituteWith;
        }
    }
}

