/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Tag;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import xdoclet.DocletContext;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.util.DocletUtil;
import xdoclet.util.Log;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;

public abstract class AbstractProgramElementTagsHandler
extends XDocletTagSupport {
    protected static String currentToken;
    protected static StringTokenizer tagTokenizer;
    protected static String matchPattern;
    private static final Comparator memberComparator;
    static /* synthetic */ Class class$xdoclet$tags$ConstructorTagsHandler;
    static /* synthetic */ Class class$xdoclet$SubTask;
    static /* synthetic */ Class class$xdoclet$tags$MethodTagsHandler;

    public static String getClassNameFor(ClassDoc clazz) {
        return clazz.name();
    }

    public static String getFullClassNameFor(ClassDoc clazz) {
        return clazz.qualifiedName();
    }

    public static String getFullSuperclassNameFor(ClassDoc clazz) {
        if (clazz.superclass() != null) {
            return clazz.superclass().qualifiedName();
        }
        return "java.lang.Object";
    }

    public static ClassDoc[] getAllClasses() {
        if (DocletContext.getInstance().getActiveSubTask().getCurrentPackage() == null) {
            return DocletContext.getInstance().getRoot().classes();
        }
        return DocletContext.getInstance().getActiveSubTask().getCurrentPackage().allClasses();
    }

    protected static boolean hasExecutableMember(ClassDoc clazz, String executableMemberName, String[] parameters, boolean setCurrentExecutableMember, int for_type) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$ConstructorTagsHandler == null ? (class$xdoclet$tags$ConstructorTagsHandler = AbstractProgramElementTagsHandler.class$("xdoclet.tags.ConstructorTagsHandler")) : class$xdoclet$tags$ConstructorTagsHandler, "hasConstructor");
        while (clazz != null) {
            ConstructorDoc[] executableMembers = null;
            switch (for_type) {
                case 3: {
                    executableMembers = clazz.constructors();
                    break;
                }
                case 1: {
                    executableMembers = clazz.methods();
                    break;
                }
                default: {
                    throw new XDocletException("Bad type: " + for_type);
                }
            }
            int i = 0;
            while (i < executableMembers.length) {
                if (executableMembers[i].name().equals(executableMemberName)) {
                    if (parameters != null) {
                        Parameter[] params = executableMembers[i].parameters();
                        cat.debug((Object)("params.length=" + params.length));
                        int j = 0;
                        while (j < params.length) {
                            cat.debug((Object)("params[j].typeName()=" + params[j].typeName()));
                            cat.debug((Object)("parameters[j]=" + parameters[j]));
                            if (parameters != null && params[j].typeName().equals(parameters[j])) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        if (setCurrentExecutableMember) {
                            switch (for_type) {
                                case 3: {
                                    XDocletTagSupport.setCurrentConstructor(executableMembers[i]);
                                    break;
                                }
                                case 1: {
                                    XDocletTagSupport.setCurrentMethod((MethodDoc)executableMembers[i]);
                                    break;
                                }
                                default: {
                                    throw new XDocletException("Bad type: " + for_type);
                                }
                            }
                        }
                        return true;
                    }
                }
                ++i;
            }
            clazz = clazz.superclass();
        }
        return false;
    }

    public void setMatchValue(String template, Properties attributes) throws XDocletException {
        matchPattern = attributes.getProperty("value");
        this.generate(template);
        matchPattern = null;
    }

    public boolean ifTagValueEquals_Impl(String template, Properties attributes, int FOR_TYPE) throws XDocletException {
        String value = attributes.getProperty("value");
        String tag_name = attributes.getProperty("tagName");
        String param_name = attributes.getProperty("paramName");
        String param_num = attributes.getProperty("paramNum");
        String tn = attributes.getProperty("tokenNumber");
        String delimiter = attributes.getProperty("delimiter");
        String return_delimiters = attributes.getProperty("returnDelimiters");
        String param_value = null;
        int param_int = -1;
        if (param_num != null) {
            param_int = Integer.valueOf(param_num);
        }
        if (XDocletTagSupport.getCurrentTag() != null && XDocletTagSupport.getCurrentTag().name().equals("@" + tag_name)) {
            Tag the_tag = XDocletTagSupport.getCurrentTag();
            String tag_value = DocletUtil.getText(the_tag);
            param_value = this.getParameterValue(tag_value, param_name, param_int);
        } else {
            param_value = this.getTagValue(tag_name, param_name, param_int, null, null, null, null, null, true, FOR_TYPE, false);
        }
        if (param_value != null) {
            return (param_value = XDocletTagSupport.tokenizeValue(param_value, tn, delimiter, return_delimiters)).equals(value);
        }
        return false;
    }

    public String matchValue() throws XDocletException {
        return matchPattern;
    }

    public String currentToken(Properties attributes) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$SubTask == null ? (class$xdoclet$SubTask = AbstractProgramElementTagsHandler.class$("xdoclet.SubTask")) : class$xdoclet$SubTask, "currentToken");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("current token:  " + currentToken));
        }
        if (currentToken == null) {
            cat.error((Object)"null token found");
            return "";
        }
        return currentToken;
    }

    public String skipToken(Properties attributes) throws XDocletException {
        if (tagTokenizer.hasMoreTokens()) {
            tagTokenizer.nextToken();
        }
        return "";
    }

    protected ExecutableMemberDoc getExecutableMemberDocForMemberName(String memberName, int for_type) throws XDocletException {
        if (memberName != null) {
            return this.extractExecutableMemberDoc(XDocletTagSupport.getCurrentClass(), memberName, for_type);
        }
        return null;
    }

    protected ExecutableMemberDoc getExecutableMemberDocForMemberName(String memberName, boolean superclasses, int for_type) throws XDocletException {
        if (!superclasses) {
            return this.getExecutableMemberDocForMemberName(memberName, for_type);
        }
        ClassDoc clazz = XDocletTagSupport.getCurrentClass();
        while (clazz != null) {
            ExecutableMemberDoc member = this.extractExecutableMemberDoc(clazz, memberName, for_type);
            if (member != null) {
                return member;
            }
            clazz = clazz.superclass();
        }
        return null;
    }

    protected char[] getIndentChars(Properties attributes) {
        String indent_str = attributes.getProperty("indent");
        if (indent_str == null) {
            return new char[0];
        }
        int indent = new Integer(indent_str);
        char[] spaces = new char[indent];
        int i = 0;
        while (i < indent) {
            spaces[i] = 32;
            ++i;
        }
        return spaces;
    }

    protected String exceptionList(Properties attributes, int for_type) throws XDocletException {
        String skip_exceptions = attributes.getProperty("skip");
        String append_exceptions = attributes.getProperty("append");
        String member_name = null;
        ClassDoc[] exceptions = null;
        ConstructorDoc executableMember = null;
        switch (for_type) {
            case 3: {
                executableMember = XDocletTagSupport.getCurrentConstructor();
                member_name = attributes.getProperty("constructor");
                break;
            }
            case 1: {
                executableMember = XDocletTagSupport.getCurrentMethod();
                member_name = attributes.getProperty("method");
                break;
            }
            default: {
                throw new XDocletException("Can't forAll for type " + for_type);
            }
        }
        if (executableMember == null && member_name == null) {
            return "";
        }
        if (member_name == null) {
            exceptions = executableMember.thrownExceptions();
        } else {
            executableMember = this.getExecutableMemberDocForMemberName(member_name, true, for_type);
            if (executableMember == null) {
                return "";
            }
            exceptions = executableMember.thrownExceptions();
        }
        StringBuffer st = new StringBuffer();
        String type = null;
        int i = 0;
        while (i < exceptions.length) {
            type = exceptions[i].toString();
            if (!this.isInSkipExceptionsList(skip_exceptions, type) && !this.isInAppendExceptionsList(append_exceptions, type)) {
                this.appendException(st, type);
            }
            ++i;
        }
        if (append_exceptions != null) {
            this.appendException(st, append_exceptions);
        }
        return st.toString();
    }

    protected void forAllMemberTagTokens(String template, Properties attributes, int for_type) throws XDocletException {
        int skip;
        Category cat = Log.getCategory(class$xdoclet$tags$MethodTagsHandler == null ? (class$xdoclet$tags$MethodTagsHandler = AbstractProgramElementTagsHandler.class$("xdoclet.tags.MethodTagsHandler")) : class$xdoclet$tags$MethodTagsHandler, "forAllMemberTagTokens");
        String tagValue = this.getTagValue(attributes, for_type);
        String delimiter = attributes.getProperty("delimiter");
        String s = attributes.getProperty("skip");
        try {
            skip = Integer.valueOf(attributes.getProperty("skip"));
        }
        catch (Throwable t) {
            skip = 0;
        }
        if (delimiter == null) {
            if (cat.isDebugEnabled()) {
                cat.debug((Object)"got null delimiter - forAllMethodTagTokens");
            }
            delimiter = ",";
        }
        tagTokenizer = new StringTokenizer(tagValue, delimiter, false);
        currentToken = "";
        matchPattern = null;
        int i = 0;
        while (tagTokenizer.hasMoreTokens() && i < skip) {
            tagTokenizer.nextToken();
            ++i;
        }
        while (tagTokenizer.hasMoreTokens()) {
            currentToken = tagTokenizer.nextToken();
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("generate current token: " + currentToken));
            }
            this.generate(template);
        }
        currentToken = null;
        tagTokenizer = null;
        matchPattern = null;
    }

    protected void forAllMemberTags(String template, Properties attributes, int for_type, String resourceKey, String[] arguments) throws XDocletException {
        FieldDoc member = null;
        switch (for_type) {
            case 2: {
                member = XDocletTagSupport.getCurrentField();
                break;
            }
            case 3: {
                member = XDocletTagSupport.getCurrentConstructor();
                break;
            }
            case 1: {
                member = XDocletTagSupport.getCurrentMethod();
                break;
            }
            default: {
                throw new XDocletException("Bad type " + for_type);
            }
        }
        if (member == null) {
            throw new XDocletException(Translator.getString(resourceKey, arguments));
        }
        Tag[] tags = DocletUtil.getTagsByName((MemberDoc)member, attributes.getProperty("tagName"));
        int i = 0;
        while (i < tags.length) {
            XDocletTagSupport.setCurrentTag(tags[i]);
            String m = this.getTagValue(attributes, for_type);
            if (matchPattern == null) {
                this.generate(template);
            } else if (matchPattern != null && (matchPattern.equals(m) || m.equals("*"))) {
                this.generate(template);
            }
            ++i;
        }
        XDocletTagSupport.setCurrentTag(null);
    }

    protected String memberComment(Properties attributes, int for_type) throws XDocletException {
        String no_comment_signs = attributes.getProperty("no-comment-signs");
        FieldDoc member = null;
        switch (for_type) {
            case 2: {
                member = XDocletTagSupport.getCurrentField();
                break;
            }
            case 3: {
                member = XDocletTagSupport.getCurrentConstructor();
                break;
            }
            case 1: {
                member = XDocletTagSupport.getCurrentMethod();
                break;
            }
            default: {
                throw new XDocletException("Bad type " + for_type);
            }
        }
        if (no_comment_signs != null && no_comment_signs.equalsIgnoreCase("true")) {
            return member.commentText();
        }
        char[] spaces = this.getIndentChars(attributes);
        Tag[] member_tags = member.tags();
        if (member_tags.length > 0) {
            StringBuffer result = new StringBuffer();
            StringTokenizer st = new StringTokenizer(member.commentText().trim(), "\n", false);
            if (st.countTokens() > 0) {
                result.append(spaces).append("/**").append("\n");
                while (st.hasMoreTokens()) {
                    result.append(spaces).append(" * ").append(st.nextToken().trim()).append("\n");
                }
                int i = 0;
                while (i < member_tags.length) {
                    String member_tag_name = member_tags[i].name();
                    if (member_tag_name.lastIndexOf(58) == -1 && member_tag_name.lastIndexOf(46) == -1) {
                        result.append(spaces).append(" * ").append(member_tags[i].name()).append(' ').append(member_tags[i].text());
                        if (i < member_tags.length - 1) {
                            result.append("\n");
                        }
                    }
                    ++i;
                }
                result.append(spaces).append(" */");
            }
            return result.toString();
        }
        return "";
    }

    protected void forAllMembers(String template, Properties attributes, int for_type) throws XDocletException {
        boolean superclasses = TypeConversionUtil.stringToBoolean(attributes.getProperty("superclasses"), true);
        boolean sort = TypeConversionUtil.stringToBoolean(attributes.getProperty("sort"), true);
        ClassDoc cur_class = XDocletTagSupport.getCurrentClass();
        HashSet<FieldDoc> already = new HashSet<FieldDoc>();
        do {
            FieldDoc[] members = null;
            switch (for_type) {
                case 2: {
                    members = cur_class.fields();
                    break;
                }
                case 3: {
                    members = cur_class.constructors();
                    break;
                }
                case 1: {
                    members = cur_class.methods();
                    break;
                }
                default: {
                    throw new XDocletException("Bad type: " + for_type);
                }
            }
            if (sort) {
                Arrays.sort(members, memberComparator);
            }
            int j = 0;
            while (j < members.length) {
                if ((superclasses || !superclasses && members[j].containingClass() == cur_class) && !"<clinit>".equals(members[j].name()) && !already.contains(members[j])) {
                    switch (for_type) {
                        case 2: {
                            XDocletTagSupport.setCurrentField(members[j]);
                            break;
                        }
                        case 3: {
                            XDocletTagSupport.setCurrentConstructor((ConstructorDoc)members[j]);
                            break;
                        }
                        case 1: {
                            XDocletTagSupport.setCurrentMethod((MethodDoc)members[j]);
                            break;
                        }
                        default: {
                            throw new XDocletException("Bad type: " + for_type);
                        }
                    }
                    already.add(members[j]);
                    this.generate(template);
                }
                ++j;
            }
        } while (superclasses && (cur_class = cur_class.superclass()) != null);
    }

    protected boolean ifHasTag_Impl(String template, Properties attributes, int for_type) throws XDocletException {
        String tag_name = attributes.getProperty("tagName");
        String param_name = attributes.getProperty("paramName");
        String param_num = attributes.getProperty("paramNum");
        String superClassesStr = attributes.getProperty("superclasses");
        boolean superClasses = TypeConversionUtil.stringToBoolean(superClassesStr, true);
        int param_int = -1;
        if (param_num != null) {
            param_int = Integer.valueOf(param_num);
        }
        switch (for_type) {
            case 1: {
                return null != XDocletTagSupport.getMethodTagValue(XDocletTagSupport.getCurrentMethod(), tag_name, param_name, param_int, null, null, false);
            }
            case 0: {
                return null != XDocletTagSupport.getClassTagValue(XDocletTagSupport.getCurrentClass(), tag_name, param_name, param_int, null, null, superClasses, false);
            }
            case 3: {
                return null != XDocletTagSupport.getConstructorTagValue(XDocletTagSupport.getCurrentConstructor(), tag_name, param_name, param_int, null, null, false);
            }
            case 2: {
                return null != XDocletTagSupport.getFieldTagValue(XDocletTagSupport.getCurrentField(), tag_name, param_name, param_int, null, null, false);
            }
        }
        throw new XDocletException(Translator.getString("bad_for_type"));
    }

    protected String checkForWrap(String pText) {
        int lIndex = pText.indexOf("\n");
        while (lIndex >= 0) {
            pText = lIndex < pText.length() - 1 ? pText.substring(0, lIndex).trim() + " " + pText.substring(lIndex + 1).trim() : pText.substring(0, lIndex);
            lIndex = pText.indexOf("\n");
        }
        return pText.trim();
    }

    private boolean isInAppendExceptionsList(String append_exceptions, String type) {
        if (append_exceptions == null) {
            return false;
        }
        return append_exceptions.indexOf(type) != -1;
    }

    private boolean isInSkipExceptionsList(String skip_exceptions, String type) {
        if (skip_exceptions == null) {
            return false;
        }
        return skip_exceptions.indexOf(type) != -1;
    }

    private void appendException(StringBuffer sb, String type) {
        if (sb.length() == 0) {
            sb.append("throws ").append(type);
        } else {
            sb.append(", ").append(type);
        }
    }

    private ExecutableMemberDoc extractExecutableMemberDoc(ClassDoc clazz, String memberName, int for_type) throws XDocletException {
        ConstructorDoc[] executableMembers;
        switch (for_type) {
            case 3: {
                executableMembers = clazz.constructors();
                break;
            }
            case 1: {
                executableMembers = clazz.methods();
                break;
            }
            default: {
                throw new XDocletException("Bad type: " + for_type);
            }
        }
        int i = 0;
        while (i < executableMembers.length) {
            if (executableMembers[i].name().equals(memberName)) {
                return executableMembers[i];
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        memberComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                MemberDoc m1 = (MemberDoc)o1;
                MemberDoc m2 = (MemberDoc)o2;
                return m1.name().compareTo(m2.name());
            }

            public boolean equals(Object obj) {
                return obj == this;
            }
        };
    }
}

