/*
 * Decompiled with CFR 0.152.
 */
package xdoclet;

import com.sun.javadoc.RootDoc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import xdoclet.ConfigParamIntrospector;
import xdoclet.ConfigParameter;
import xdoclet.DocletContext;
import xdoclet.SubTask;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.template.TemplateException;
import xdoclet.util.Log;
import xdoclet.util.Translator;

public class DocletTask
extends Task {
    public static final String XDOCLET_VERSION = "1.1.2";
    protected transient DocletContext context = null;
    private File destDir;
    private File mergeDir;
    private Path sourcePath;
    private Path classpath;
    private Reference classpathRef;
    private Vector filesets = new Vector();
    private String packageNames = null;
    private String excludePackageNames = null;
    private String excludedTags = null;
    private String maxmemory = null;
    private boolean force = false;
    private Vector templates = new Vector();
    private Vector configParams = new Vector();
    static /* synthetic */ Class class$xdoclet$DocletTask;

    public Vector getConfigParams() {
        return this.configParams;
    }

    public File getMergeDir() {
        return this.mergeDir;
    }

    public Path getSourcePath() {
        return this.sourcePath;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Reference getClasspathRef() {
        return this.classpathRef;
    }

    public Vector getFilesets() {
        return this.filesets;
    }

    public String getPackageNames() {
        return this.packageNames;
    }

    public String getExcludePackageNames() {
        return this.excludePackageNames;
    }

    public String getExcludedTags() {
        return this.excludedTags;
    }

    public Vector getTemplates() {
        return this.templates;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public String getMaxmemory() {
        return this.maxmemory;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setPackageNames(String src) {
        this.packageNames = src;
    }

    public void setExcludePackageNames(String src) {
        this.excludePackageNames = src;
    }

    public void setExcludedTags(String tags) {
        this.excludedTags = tags;
    }

    public void setDestDir(File dir) {
        this.destDir = dir;
    }

    public void setMergeDir(File dir) {
        this.mergeDir = dir;
    }

    public void setSourcepath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public void setClasspath(Path src) {
        if (this.classpath == null) {
            this.classpath = src;
        } else {
            this.classpath.append(src);
        }
    }

    public void setClasspathRef(Reference ref) {
        this.classpathRef = ref;
        this.createClasspath().setRefid(ref);
    }

    public void setMaxmemory(String maxmemory) {
        this.maxmemory = maxmemory;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(((ProjectComponent)this).project);
        }
        return this.sourcePath.createPath();
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void addTemplate(TemplateSubTask subtask) {
        this.templates.addElement(subtask);
    }

    public void addXmlTemplate(XmlSubTask subtask) {
        this.templates.addElement(subtask);
    }

    public void addConfigParam(ConfigParameter config_param) {
        this.configParams.addElement(config_param);
    }

    public void execute() throws BuildException {
        Category cat = Log.getCategory(class$xdoclet$DocletTask == null ? (class$xdoclet$DocletTask = DocletTask.class$("xdoclet.DocletTask")) : class$xdoclet$DocletTask, "execute");
        this.validateOptions();
        cat.debug((Object)"Options validated.");
        try {
            this.saveContext(this.getContext(), "DocletContext.edc");
            cat.debug((Object)"Context saved.");
            this.createTask().execute();
            cat.debug((Object)"Task executed.");
        }
        catch (IOException ex) {
            cat.error((Object)"IO error!", (Throwable)ex);
            try {
                throw new BuildException(Translator.getString("context_write_error", new String[]{this.getTaskName()}));
            }
            catch (XDocletException xe) {
                throw new BuildException((Throwable)xe);
            }
        }
    }

    protected Vector getSubTasks() {
        Vector<SubTask> true_subtasks = new Vector<SubTask>();
        int i = 0;
        while (i < this.templates.size()) {
            TemplateSubTask holder = (TemplateSubTask)this.templates.elementAt(i);
            SubTask subtask = this.getSubTaskFromPlaceHolder(holder);
            if (subtask == null) {
                try {
                    System.out.println(Translator.getString("couldnt_instantiate_subtask", new String[]{holder.getSubTaskClassName()}));
                }
                catch (XDocletException xe) {
                    System.out.println(xe.getMessage());
                }
            } else {
                true_subtasks.addElement(subtask);
            }
            ++i;
        }
        return true_subtasks;
    }

    protected SubTask getSubTaskFromPlaceHolder(TemplateSubTask holder) {
        if (holder.getSubTaskClassName() == null) {
            return holder;
        }
        try {
            Class<?> subtask_class = Class.forName(holder.getSubTaskClassName());
            TemplateSubTask subtask = (TemplateSubTask)subtask_class.newInstance();
            subtask.copyAttributesFrom(holder);
            return subtask;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    protected DocletContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        Vector subtasks = this.getSubTasks();
        Hashtable configs = this.getConfigParams(subtasks);
        this.context = new DocletContext(this.sourcePath.toString(), this.classpath.toString(), this.destDir.toString(), this.mergeDir != null ? this.mergeDir.toString() : null, this.excludedTags, subtasks.toArray(new SubTask[0]), ((ProjectComponent)this).project.getProperties(), configs, this.force);
        DocletContext.setSingleInstance(this.context);
        return this.context;
    }

    protected Hashtable getConfigParams(Vector subtasks) {
        Hashtable configs = new Hashtable();
        ConfigParamIntrospector.fillConfigParamsFor(this, configs);
        int i = 0;
        while (i < subtasks.size()) {
            SubTask sub_task = (SubTask)subtasks.elementAt(i);
            if (sub_task != null) {
                ConfigParamIntrospector.fillConfigParamsFor(sub_task, configs);
                this.fillWithUserDefinedConfigParams(configs, sub_task.getConfigParams(), sub_task.getSubTaskName() + ".");
            }
            ++i;
        }
        this.fillWithUserDefinedConfigParams(configs, this.getConfigParams(), "");
        return configs;
    }

    protected void validateOptions() throws BuildException {
        try {
            if (this.destDir == null) {
                throw new BuildException(Translator.getString("attribute_not_present_error", new String[]{"destDir"}), this.location);
            }
            if (this.sourcePath == null) {
                throw new BuildException(Translator.getString("attribute_not_present_error", new String[]{"sourcePath"}), this.location);
            }
            if (this.sourcePath.list().length == 0) {
                throw new BuildException(Translator.getString("attribute_not_set_error", new String[]{"sourcePath"}), this.location);
            }
            if (this.classpath == null) {
                this.classpath = Path.systemClasspath;
            }
            if (this.packageNames == null && this.filesets.size() == 0 || this.packageNames != null && this.filesets.size() > 0) {
                throw new BuildException(Translator.getString("no_packagenames_or_filesets"), this.location);
            }
        }
        catch (XDocletException xe) {
            throw new BuildException((Throwable)xe);
        }
        this.validateSubTasks();
    }

    protected void validateSubTasks() throws BuildException {
        DocletContext context = this.getContext();
        SubTask[] subtasks = context.getSubTasks();
        int i = 0;
        while (i < subtasks.length) {
            SubTask subtask = subtasks[i];
            if (subtask != null) {
                try {
                    subtask.validateOptions();
                }
                catch (XDocletException ex) {
                    new BuildException(subtask.getSubTaskName() + ": " + ex.getMessage(), this.location);
                }
            }
            ++i;
        }
    }

    protected Javadoc createTask() throws BuildException {
        Javadoc javadoc = (Javadoc)((ProjectComponent)this).project.createTask("javadoc");
        javadoc.setVerbose(false);
        javadoc.setFailonerror(true);
        javadoc.setPrivate(true);
        javadoc.setUseExternalFile(true);
        if (this.getMaxmemory() != null) {
            javadoc.setMaxmemory(this.getMaxmemory());
        }
        javadoc.setOwningTarget(this.getOwningTarget());
        javadoc.setTaskName(this.getTaskName());
        javadoc.setDescription(this.getDescription());
        if (this.packageNames != null) {
            javadoc.setPackagenames(this.packageNames);
        } else if (this.filesets.size() > 0) {
            String comma_sep_list = "";
            int i = 0;
            while (i < this.filesets.size()) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
                File from_dir = fs.getDir(((ProjectComponent)this).project);
                String[] src_files = ds.getIncludedFiles();
                int j = 0;
                while (j < src_files.length) {
                    File source_file = new File(from_dir + File.separator + src_files[j]);
                    if (source_file.getName().endsWith(".java")) {
                        comma_sep_list = comma_sep_list + source_file.toString();
                        comma_sep_list = comma_sep_list + ",";
                    }
                    ++j;
                }
                ++i;
            }
            javadoc.setSourcefiles(comma_sep_list);
        }
        String log4j_config_file = System.getProperty("log4j.configuration");
        if (log4j_config_file != null) {
            javadoc.setAdditionalparam("-J-Dlog4j.configuration=" + log4j_config_file);
        }
        javadoc.setSourcepath(this.sourcePath);
        javadoc.setClasspath(this.classpath);
        javadoc.setClasspathRef(this.classpathRef);
        Javadoc.DocletInfo doclet = javadoc.createDoclet();
        doclet.setName("xdoclet.DocletTask$DocletMain");
        doclet.setPath(this.classpath);
        doclet.setPathRef(this.classpathRef);
        return javadoc;
    }

    protected void saveContext(DocletContext context, String file_name) throws IOException {
        FileOutputStream fos = new FileOutputStream(System.getProperty("java.io.tmpdir") + File.separator + file_name);
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        oos.writeObject(context);
        oos.flush();
        fos.close();
    }

    private void fillWithUserDefinedConfigParams(Hashtable configs, Vector config_params, String prefix) {
        int i = 0;
        while (i < config_params.size()) {
            ConfigParameter config_param = (ConfigParameter)config_params.elementAt(i);
            configs.put((prefix + config_param.getName()).toLowerCase(), config_param.getValue());
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class DocletMain {
        static /* synthetic */ Class class$xdoclet$DocletTask$DocletMain;

        public static boolean start(RootDoc root) throws XDocletException {
            Category cat = Log.getCategory(class$xdoclet$DocletTask$DocletMain == null ? (class$xdoclet$DocletTask$DocletMain = DocletMain.class$("xdoclet.DocletTask$DocletMain")) : class$xdoclet$DocletTask$DocletMain, "start");
            try {
                DocletContext.setSingleInstance(DocletMain.loadContext());
                if (cat.isDebugEnabled()) {
                    cat.debug((Object)"Context successfully loaded.");
                }
                DocletContext.getInstance().setRoot(root);
                SubTask[] subtasks = DocletContext.getInstance().getSubTasks();
                int i = 0;
                while (i < subtasks.length) {
                    if (subtasks[i] != null) {
                        if (cat.isDebugEnabled()) {
                            cat.debug((Object)("SubTask " + subtasks[i].getSubTaskName() + "Initialized."));
                        }
                        subtasks[i].init();
                        DocletContext.getInstance().setActiveSubTask(subtasks[i]);
                        System.out.println(Translator.getString("running_taskname", new String[]{"<" + subtasks[i].getSubTaskName() + "/>"}));
                        subtasks[i].execute();
                    }
                    ++i;
                }
                return true;
            }
            catch (IOException e) {
                System.out.println(Translator.getString("context_read_error"));
                if (cat.isDebugEnabled()) {
                    cat.error((Object)"IOException", (Throwable)e);
                }
                return false;
            }
            catch (XDocletException e) {
                System.out.println(Translator.getString("running_failed"));
                System.out.println("<<" + e.getMessage() + ">>");
                if (e.getNestedException() instanceof TemplateException) {
                    TemplateException template_ex = (TemplateException)e.getNestedException();
                    if (cat.isDebugEnabled()) {
                        cat.error((Object)("Template Exception = " + template_ex));
                        cat.error((Object)("Nested Exception = " + template_ex.getNestedException()));
                    }
                }
                if (cat.isDebugEnabled()) {
                    cat.error((Object)("Exception trace:\n" + e.getPrintStackTrace()));
                }
                throw e;
            }
        }

        private static DocletContext loadContext() throws IOException, XDocletException {
            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "DocletContext.edc");
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fis));
            DocletContext context = null;
            try {
                context = (DocletContext)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new XDocletException(Translator.getString("incorrect_classpath"));
            }
            fis.close();
            file.delete();
            return context;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

