/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.tdb.TDBFactory;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public class Test_SPARQL_TDB
extends BaseTest {
    @Test
    public void sparql1() {
        String graphName = "http://example/";
        Triple triple = SSE.parseTriple((String)"(<x> <y> 123)");
        Dataset ds = TDBFactory.createDataset();
        Graph g2 = ds.asDatasetGraph().getGraph(Node.createURI((String)graphName));
        g2.add(triple);
        Model m = ModelFactory.createModelForGraph((Graph)g2);
        String qs = "SELECT * { ?s ?p ?o . FILTER ( ?o < 456 ) }";
        Query query = QueryFactory.create((String)qs);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);
        ResultSet rs = qexec.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
    }

    @Test
    public void sparql2() {
        String graphName = "http://example/";
        Triple triple = SSE.parseTriple((String)"(<x> <y> 123)");
        Dataset ds = TDBFactory.createDataset();
        Graph g2 = ds.asDatasetGraph().getGraph(Node.createURI((String)graphName));
        g2.add(triple);
        Model m = ModelFactory.createModelForGraph((Graph)g2);
        String qs = "SELECT * { ?s ?p ?o . }";
        Query query = QueryFactory.create((String)qs);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);
        ResultSet rs = qexec.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
    }

    @Test
    public void sparql3() {
        Dataset dataset = TDBFactory.createDataset();
        Query query = QueryFactory.create((String)"SELECT ?g { GRAPH ?g {} }");
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        ResultSet rs = qExec.execSelect();
        int n = ResultSetFormatter.consume((ResultSet)rs);
        Test_SPARQL_TDB.assertEquals((long)0L, (long)n);
    }

    @Test
    public void sparql4() {
        Dataset dataset = TDBFactory.createDataset();
        String graphName = "http://example/";
        Triple triple = SSE.parseTriple((String)"(<x> <y> 123)");
        Graph g2 = dataset.asDatasetGraph().getGraph(Node.createURI((String)graphName));
        g2.add(triple);
        Query query = QueryFactory.create((String)"SELECT ?g { GRAPH ?g {} }");
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        ResultSet rs = qExec.execSelect();
        int n = ResultSetFormatter.consume((ResultSet)rs);
        Test_SPARQL_TDB.assertEquals((long)1L, (long)n);
    }
}

