/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.SetupTDB;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public class TestTripleTable
extends BaseTest {
    static Node n1;
    static Node n2;
    static Node n3;
    static Node n4;
    static Node n5;
    static Node n6;

    private static void add(TripleTable table, Node s, Node p, Node o) {
        table.add(new Triple(s, p, o));
    }

    private static void notMatch(TripleTable table, Node s, Node p, Node o) {
        Iterator iter = table.find(s, p, o);
        TestTripleTable.assertNotNull((Object)iter);
        TestTripleTable.assertFalse((boolean)iter.hasNext());
    }

    private static void match(TripleTable table, Node s, Node p, Node o) {
        Iterator iter = table.find(s, p, o);
        TestTripleTable.assertNotNull((Object)iter);
        TestTripleTable.assertTrue((boolean)iter.hasNext());
    }

    private static void contains(TripleTable table, Node s, Node p, Node o) {
        Iterator iter = table.find(s, p, o);
        TestTripleTable.assertNotNull((Object)iter);
        TestTripleTable.assertTrue((boolean)iter.hasNext());
        TestTripleTable.assertEquals((Object)new Triple(s, p, o), iter.next());
        TestTripleTable.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void createTripleTable1() {
        TripleTable table = this.createTripleTableMem();
        TestTripleTable.notMatch(table, n1, n2, n3);
    }

    @Test
    public void add1() {
        TripleTable table = this.createTripleTableMem();
        table.add(new Triple(n1, n2, n3));
    }

    @Test
    public void find1() {
        TripleTable table = this.createTripleTableMem();
        TestTripleTable.add(table, n1, n2, n3);
        TestTripleTable.contains(table, n1, n2, n3);
        TestTripleTable.notMatch(table, n1, n2, n4);
    }

    @Test
    public void find2() {
        TripleTable table = this.createTripleTableMem();
        TestTripleTable.add(table, n1, n2, n3);
        TestTripleTable.add(table, n1, n2, n4);
        TestTripleTable.contains(table, n1, n2, n3);
        TestTripleTable.contains(table, n1, n2, n4);
    }

    @Test
    public void find3() {
        TripleTable table = this.createTripleTableMem();
        TestTripleTable.add(table, n1, n2, n3);
        TestTripleTable.add(table, n4, n5, n6);
        TestTripleTable.contains(table, n1, n2, n3);
        TestTripleTable.contains(table, n4, n5, n6);
        TestTripleTable.notMatch(table, n1, n2, n4);
    }

    @Test
    public void find4() {
        TripleTable table = this.createTripleTableMem();
        TestTripleTable.add(table, n1, n2, n3);
        TestTripleTable.add(table, n4, n5, n6);
        TestTripleTable.match(table, Node.ANY, n2, n3);
        TestTripleTable.match(table, null, n2, n3);
        TestTripleTable.match(table, null, null, null);
    }

    private TripleTable createTripleTableMem() {
        DatasetGraphTDB ds = SetupTDB.buildDataset((Location)Location.mem());
        return ds.getTripleTable();
    }

    static {
        Logger.getLogger((String)"com.hp.hpl.jena.tdb.info").setLevel(Level.WARN);
        Logger.getLogger((String)"com.hp.hpl.jena.tdb.exec").setLevel(Level.WARN);
        n1 = NodeFactory.parseNode((String)"<http://example/n1>");
        n2 = NodeFactory.parseNode((String)"<http://example/n2>");
        n3 = NodeFactory.parseNode((String)"<http://example/n3>");
        n4 = NodeFactory.parseNode((String)"<http://example/n4>");
        n5 = NodeFactory.parseNode((String)"<http://example/n5>");
        n6 = NodeFactory.parseNode((String)"<http://example/n6>");
    }
}

