/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestQuadFilter
extends BaseTest {
    private static String graphToHide = "http://example/g2";
    private static Dataset ds = TestQuadFilter.setup();

    @BeforeClass
    public static void beforeClass() {
    }

    @AfterClass
    public static void afterClass() {
    }

    private static Dataset setup() {
        Dataset ds = TDBFactory.createDataset();
        DatasetGraphTDB dsg = (DatasetGraphTDB)ds.asDatasetGraph();
        Quad q1 = SSE.parseQuad((String)"(<http://example/g1> <http://example/s> <http://example/p> <http://example/o1>)");
        Quad q2 = SSE.parseQuad((String)"(<http://example/g2> <http://example/s> <http://example/p> <http://example/o2>)");
        dsg.add(q1);
        dsg.add(q2);
        return ds;
    }

    private static Filter<Tuple<NodeId>> createFilter(Dataset ds) {
        DatasetGraphTDB dsg = (DatasetGraphTDB)ds.asDatasetGraph();
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        final NodeId target = nodeTable.getNodeIdForNode(Node.createURI((String)graphToHide));
        Filter<Tuple<NodeId>> filter = new Filter<Tuple<NodeId>>(){

            public boolean accept(Tuple<NodeId> item) {
                return item.size() != 4 || !((NodeId)item.get(0)).equals((Object)target);
            }
        };
        return filter;
    }

    @Test
    public void quad_filter_1() {
        this.test("SELECT * { GRAPH ?g { ?s ?p ?o } }", 1, 2);
    }

    @Test
    public void quad_filter_2() {
        this.test("SELECT * { ?s ?p ?o }", 1, 2);
    }

    @Test
    public void quad_filter_3() {
        this.test("SELECT * { GRAPH ?g { } }", 1, 2);
    }

    private void test(String qs, int withFilter, int withoutFilter) {
        Filter<Tuple<NodeId>> filter = TestQuadFilter.createFilter(ds);
        Query query = QueryFactory.create((String)qs);
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)ds);
        qExec.getContext().set(SystemTDB.symTupleFilter, filter);
        qExec.getContext().setTrue(TDB.symUnionDefaultGraph);
        long x1 = ResultSetFormatter.consume((ResultSet)qExec.execSelect());
        qExec.close();
        TestQuadFilter.assertEquals((long)withFilter, (long)x1);
        qExec = QueryExecutionFactory.create((Query)query, (Dataset)ds);
        qExec.getContext().setTrue(TDB.symUnionDefaultGraph);
        long x2 = ResultSetFormatter.consume((ResultSet)qExec.execSelect());
        qExec.close();
        TestQuadFilter.assertEquals((long)withoutFilter, (long)x2);
    }
}

