/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.tdb.store.NodeId;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public class TestNodeId
extends BaseTest {
    @Test
    public void nodeId_01() {
        NodeId nodeId = NodeId.create((long)37L);
        TestNodeId.assertEquals((long)37L, (long)nodeId.getId());
    }

    @Test
    public void nodeId_02() {
        NodeId nodeId = NodeId.create((long)-1L);
        TestNodeId.assertEquals((long)-1L, (long)nodeId.getId());
    }

    @Test
    public void nodeId_int_1() {
        this.test("1", NodeFactory.parseNode((String)"1"));
    }

    @Test
    public void nodeId_int_2() {
        this.test("2", NodeFactory.parseNode((String)"2"));
    }

    @Test
    public void nodeId_int_3() {
        this.test("'3'^^xsd:int", NodeFactory.parseNode((String)"3"));
    }

    @Test
    public void nodeId_int_4() {
        this.test("'3'", (Node)null);
    }

    @Test
    public void nodeId_int_5() {
        this.test("-1", NodeFactory.parseNode((String)"-1"));
    }

    @Test
    public void nodeId_int_6() {
        this.test("-180", NodeFactory.parseNode((String)"-180"));
    }

    @Test
    public void nodeId_int_7() {
        this.test("01", NodeFactory.parseNode((String)"1"));
    }

    @Test
    public void nodeId_int_8() {
        this.test("+01", NodeFactory.parseNode((String)"1"));
    }

    @Test
    public void nodeId_decimal_1() {
        this.test("3.14", NodeFactory.parseNode((String)"3.14"));
    }

    @Test
    public void nodeId_decimal_2() {
        this.test("123456789.123456789", (Node)null);
    }

    @Test
    public void nodeId_decimal_3() {
        this.test("12.89", Node.createLiteral((String)"12.89", null, (RDFDatatype)XSDDatatype.XSDdecimal));
    }

    @Test
    public void nodeId_decimal_4() {
        this.test("-1.0", NodeFactory.parseNode((String)"-1.0"));
    }

    @Test
    public void nodeId_dateTime_01() {
        this.test("'2008-04-28T15:36:15+01:00'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_02() {
        this.test("'2008-04-28T15:36:15Z'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_03() {
        this.test("'2008-04-28T15:36:15+00:00'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_04() {
        this.test("'2008-04-28T15:36:15-05:00'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_05() {
        this.test("'2008-04-28T15:36:15'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_06() {
        this.test("'2008-04-28T15:36:05.450'^^xsd:dateTime", "'2008-04-28T15:36:05.45'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_08() {
        this.test("'8008-04-28T15:36:05.45'^^xsd:dateTime", (Node)null);
    }

    @Test
    public void nodeId_dateTime_09() {
        this.test("'2008-04-28T15:36:05.001'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_10() {
        this.test("'2008-04-28T15:36:05.01'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_11() {
        this.test("'2008-04-28T15:36:05.1'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_12() {
        this.test("'2008-04-28T15:36:05.010'^^xsd:dateTime", "'2008-04-28T15:36:05.01'^^xsd:dateTime");
    }

    @Test
    public void nodeId_dateTime_13() {
        this.test("'2008-04-28T15:36:05.100'^^xsd:dateTime", "'2008-04-28T15:36:05.1'^^xsd:dateTime");
    }

    @Test
    public void nodeId_date_1() {
        this.test("'2008-04-28Z'^^xsd:date", NodeFactory.parseNode((String)"'2008-04-28Z'^^xsd:date"));
    }

    @Test
    public void nodeId_date_2() {
        this.test("'2008-04-28+00:00'^^xsd:date", NodeFactory.parseNode((String)"'2008-04-28+00:00'^^xsd:date"));
    }

    @Test
    public void nodeId_date_3() {
        this.test("'2008-04-28-05:00'^^xsd:date", NodeFactory.parseNode((String)"'2008-04-28-05:00'^^xsd:date"));
    }

    @Test
    public void nodeId_date_4() {
        this.test("'2008-04-28+02:00'^^xsd:date", NodeFactory.parseNode((String)"'2008-04-28+02:00'^^xsd:date"));
    }

    @Test
    public void nodeId_date_5() {
        this.test("'8008-04-28'^^xsd:date", (Node)null);
    }

    @Test
    public void nodeId_boolean_1() {
        this.test("'true'^^xsd:boolean", NodeFactory.parseNode((String)"'true'^^xsd:boolean"));
    }

    @Test
    public void nodeId_boolean_2() {
        this.test("'false'^^xsd:boolean", NodeFactory.parseNode((String)"'false'^^xsd:boolean"));
    }

    @Test
    public void nodeId_boolean_3() {
        this.test("'1'^^xsd:boolean", NodeFactory.parseNode((String)"'true'^^xsd:boolean"));
    }

    @Test
    public void nodeId_boolean_4() {
        this.test("'0'^^xsd:boolean", NodeFactory.parseNode((String)"'false'^^xsd:boolean"));
    }

    private void test(String x) {
        this.test(x, x);
    }

    private void test(String x, String expected) {
        this.test(x, NodeFactory.parseNode((String)expected));
    }

    private void test(String x, Node correct) {
        Node n = NodeFactory.parseNode((String)x);
        NodeId nodeId = NodeId.inline((Node)n);
        if (correct == null) {
            TestNodeId.assertNull((Object)nodeId);
            return;
        }
        Node n2 = NodeId.extract((NodeId)nodeId);
        TestNodeId.assertNotNull((Object)n2);
        String s = "(" + correct.getLiteralLexicalForm() + "," + n2.getLiteralLexicalForm() + ")";
        TestNodeId.assertTrue((String)("Not same value: " + s), (boolean)correct.sameValueAs((Object)n2));
        TestNodeId.assertEquals((String)"Not same term", (Object)correct, (Object)n2);
    }
}

