/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.TDBLoader;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.logging.Log;

public class TestLoader
extends BaseTest {
    private static final String DIR = "testing/Loader/";
    private static final Node g = Node.createURI((String)"g");
    private static final Node s = Node.createURI((String)"s");
    private static final Node p = Node.createURI((String)"p");
    private static final Node o = Node.createURI((String)"o");

    @BeforeClass
    public static void beforeClass() {
        Log.disable((String)"com.hp.hpl.jena.arq.exec");
        Log.disable((String)"com.hp.hpl.jena.tdb.loader");
    }

    @AfterClass
    public static void afterClass() {
        Log.enable((String)"com.hp.hpl.jena.arq.exec");
        Log.enable((String)"com.hp.hpl.jena.tdb.loader");
    }

    @Test
    public void load_dataset_01() {
        DatasetGraphTDB dsg = TDBFactory.createDatasetGraph();
        TDBLoader.load((DatasetGraphTDB)dsg, (String)"testing/Loader/data-1.nq", (boolean)false);
        TestLoader.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        TestLoader.assertEquals((long)1L, (long)dsg.getGraph(g).size());
    }

    @Test
    public void load_dataset_02() {
        DatasetGraphTDB dsg = TDBFactory.createDatasetGraph();
        InputStream in = IO.openFile((String)"testing/Loader/data-1.nq");
        TDBLoader.load((DatasetGraphTDB)dsg, (InputStream)in, (boolean)false);
        TestLoader.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        TestLoader.assertEquals((long)1L, (long)dsg.getGraph(g).size());
    }

    @Test
    public void load_graph_01() {
        DatasetGraphTDB dsg = TDBFactory.createDatasetGraph();
        TDBLoader.load((DatasetGraphTDB)dsg, (String)"testing/Loader/data-2.nt", (boolean)false);
        TestLoader.assertEquals((long)1L, (long)dsg.getDefaultGraph().size());
    }

    @Test
    public void load_graph_02() {
        DatasetGraphTDB dsg = TDBFactory.createDatasetGraph();
        TDBLoader.load((GraphTDB)dsg.getDefaultGraphTDB(), (String)"testing/Loader/data-2.nt", (boolean)false);
        TestLoader.assertEquals((long)1L, (long)dsg.getDefaultGraph().size());
    }

    @Test
    public void load_graph_03() {
        DatasetGraphTDB dsg = TDBFactory.createDatasetGraph();
        TDBLoader.load((GraphTDB)dsg.getGraphTDB(g), (String)"testing/Loader/data-2.nt", (boolean)false);
        TestLoader.assertEquals((long)0L, (long)dsg.getDefaultGraph().size());
        TestLoader.assertEquals((long)1L, (long)dsg.getGraph(g).size());
        List x = Iter.toList((Iterator)dsg.getDefaultGraph().find(null, null, null));
        TestLoader.assertEquals((long)0L, (long)x.size());
        x = Iter.toList((Iterator)dsg.getGraph(g).find(null, null, null));
        TestLoader.assertEquals((long)1L, (long)x.size());
        x = Iter.toList((Iterator)dsg.getGraph(g).find(s, null, null));
        TestLoader.assertEquals((long)1L, (long)x.size());
        x = Iter.toList((Iterator)dsg.getGraph(g).find(null, p, null));
        TestLoader.assertEquals((long)1L, (long)x.size());
        x = Iter.toList((Iterator)dsg.getGraph(g).find(null, null, o));
        TestLoader.assertEquals((long)1L, (long)x.size());
        List z = Iter.toList((Iterator)dsg.find(null, null, null, null));
        TestLoader.assertEquals((long)1L, (long)z.size());
        z = Iter.toList((Iterator)dsg.find(g, null, null, null));
        TestLoader.assertEquals((long)1L, (long)z.size());
        z = Iter.toList((Iterator)dsg.find(null, s, null, null));
        TestLoader.assertEquals((long)1L, (long)z.size());
        z = Iter.toList((Iterator)dsg.find(null, null, p, null));
        TestLoader.assertEquals((long)1L, (long)z.size());
        z = Iter.toList((Iterator)dsg.find(null, null, null, o));
        TestLoader.assertEquals((long)1L, (long)z.size());
    }
}

