/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.migrate.DynamicDatasets;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.StrUtils;

public class TestDynamicDataset
extends BaseTest {
    static Dataset dataset;
    private static String dataStr;
    private static Dataset dataset2;
    private static Node gn1;
    private static Node gn2;
    private static Node gn3;
    private static Node gn9;
    private static final String prefix = "PREFIX : <http://example/> ";

    private static void init() {
        for (int i = 0; i < 5; ++i) {
            TestDynamicDataset.addGraph(dataset, i);
        }
        Model m = dataset.getDefaultModel();
        Triple t1 = SSE.parseTriple((String)"(<uri:x> <uri:p> 0)");
        Triple t2 = SSE.parseTriple((String)"(<uri:y> <uri:q> 'ABC')");
        Triple t3 = SSE.parseTriple((String)"(<uri:z> <uri:property> 'DEF')");
        m.getGraph().add(t1);
        m.getGraph().add(t2);
        m.getGraph().add(t3);
    }

    private static void addGraph(Dataset dataset, int i) {
        Model m = dataset.getNamedModel("graph:" + i);
        Triple t1 = SSE.parseTriple((String)("(<uri:x> <uri:p> " + i + ")"));
        Triple t2 = SSE.parseTriple((String)"(<uri:y> <uri:q> 'ABC')");
        m.getGraph().add(t1);
        m.getGraph().add(t2);
    }

    @Test
    public void dynamic01() {
        TestDynamicDataset.testCount("SELECT * {?s ?p ?o}", 3, dataset);
    }

    @Test
    public void dynamic02() {
        TestDynamicDataset.testCount("SELECT ?g { GRAPH ?g {} }", 5, dataset);
    }

    @Test
    public void dynamic03() {
        TestDynamicDataset.testCount("SELECT * FROM <graph:1> {?s <uri:p> ?o}", 1, dataset);
    }

    @Test
    public void dynamic04() {
        TestDynamicDataset.testCount("SELECT * FROM <graph:1> { GRAPH ?g { ?s ?p ?o} }", 0, dataset);
    }

    @Test
    public void dynamic05() {
        TestDynamicDataset.testCount("SELECT * FROM <graph:1> FROM <graph:2> {?s <uri:p> ?o}", 2, dataset);
    }

    @Test
    public void dynamic06() {
        TestDynamicDataset.testCount("SELECT ?s FROM <graph:1> FROM <graph:2> {?s <uri:q> ?o}", 1, dataset);
    }

    @Test
    public void dynamic07() {
        TestDynamicDataset.testCount("SELECT ?s FROM NAMED <graph:1> {?s <uri:q> ?o}", 0, dataset);
    }

    @Test
    public void dynamic08() {
        TestDynamicDataset.testCount("SELECT ?s FROM <graph:2> FROM NAMED <graph:1> {?s <uri:q> ?o}", 1, dataset);
    }

    @Test
    public void dynamic09() {
        TestDynamicDataset.testCount("SELECT * FROM <graph:1> FROM <graph:2> FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH ?g { ?s <uri:q> ?o }}", 2, dataset);
    }

    @Test
    public void dynamic10() {
        TestDynamicDataset.testCount("SELECT * FROM <graph:1> FROM <graph:2>FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH ?g { ?s <uri:q> ?o }}", 2, dataset);
    }

    @Test
    public void dynamic11() {
        TestDynamicDataset.testCount("SELECT * FROM <x:unknown>{ GRAPH ?g { ?s <uri:q> ?o }}", 0, dataset);
    }

    @Test
    public void dynamic12() {
        TestDynamicDataset.testCount("SELECT * FROM  <graph:1>{ GRAPH ?g { }}", 0, dataset);
    }

    @Test
    public void dynamic13() {
        TestDynamicDataset.testCount("SELECT * FROM NAMED <graph:1>{ GRAPH ?g { }}", 1, dataset);
    }

    @Test
    public void dynamic14() {
        TestDynamicDataset.testCount("SELECT * FROM NAMED <graph:1> FROM NAMED <graph:2>FROM <graph:3> { GRAPH ?g { }}", 2, dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicAndUnion1() {
        try {
            TDB.getContext().setTrue(TDB.symUnionDefaultGraph);
            TestDynamicDataset.testCount("SELECT * FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH ?g { ?s <uri:q> ?o }}", 2, dataset);
            TDB.getContext().unset(TDB.symUnionDefaultGraph);
        }
        finally {
            TDB.getContext().unset(TDB.symUnionDefaultGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicAndUnion2() {
        try {
            TDB.getContext().setTrue(TDB.symUnionDefaultGraph);
            TestDynamicDataset.testCount("SELECT * FROM NAMED <graph:3> FROM NAMED <graph:4> { ?s <uri:q> ?o }", 1, dataset);
        }
        finally {
            TDB.getContext().unset(TDB.symUnionDefaultGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicAndUnion3() {
        try {
            TDB.getContext().setTrue(TDB.symUnionDefaultGraph);
            TestDynamicDataset.testCount("SELECT * FROM NAMED <graph:3> FROM NAMED <graph:4> { ?s <uri:p> ?o }", 2, dataset);
        }
        finally {
            TDB.getContext().unset(TDB.symUnionDefaultGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicAndUnion4() {
        try {
            TDB.getContext().setTrue(TDB.symUnionDefaultGraph);
            TestDynamicDataset.testCount("SELECT * FROM <graph:1> FROM <graph:2>FROM NAMED <graph:3> FROM NAMED <graph:4> { ?s <uri:p> ?o }", 2, dataset);
        }
        finally {
            TDB.getContext().unset(TDB.symUnionDefaultGraph);
        }
    }

    @Test
    public void dynamicAndUnion5() {
        TestDynamicDataset.testCount("SELECT * FROM <graph:1>FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH <urn:x-arq:DefaultGraph> { ?s <uri:p> ?o } }", 1, dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicAndUnion6() {
        try {
            TDB.getContext().setTrue(TDB.symUnionDefaultGraph);
            TestDynamicDataset.testCount("SELECT * FROM <graph:1>FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH <urn:x-arq:DefaultGraph> { ?s <uri:p> ?o } }", 1, dataset);
        }
        finally {
            TDB.getContext().unset(TDB.symUnionDefaultGraph);
        }
    }

    @Test
    public void dynamicAndUnion7() {
        TestDynamicDataset.testCount("SELECT * FROM <graph:1>FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH <urn:x-arq:UnionGraph> { ?s <uri:p> ?o } }", 2, dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicAndUnion8() {
        try {
            TDB.getContext().setTrue(TDB.symUnionDefaultGraph);
            TestDynamicDataset.testCount("SELECT * FROM <graph:1>FROM NAMED <graph:3> FROM NAMED <graph:4> { GRAPH <urn:x-arq:UnionGraph> { ?s <uri:p> ?o } }", 2, dataset);
        }
        finally {
            TDB.getContext().unset(TDB.symUnionDefaultGraph);
        }
    }

    @Test
    public void dynamicAndUnion10() {
        TestDynamicDataset.testCount("SELECT * FROM <urn:x-arq:DefaultGraph>{ ?s ?p ?o }", 3, dataset);
    }

    @Test
    public void dynamicAndUnion10a() {
        TestDynamicDataset.testCount("SELECT * FROM <urn:x-arq:DefaultGraph>{ GRAPH ?g { ?s ?p ?o } }", 0, dataset);
    }

    @Test
    public void dynamicAndUnion11() {
        TestDynamicDataset.testCount("SELECT * FROM <urn:x-arq:UnionGraph>{ ?s ?p ?o }", 6, dataset);
    }

    @Test
    public void dynamicAndUnion11a() {
        TestDynamicDataset.testCount("SELECT * FROM <urn:x-arq:UnionGraph>{ GRAPH ?g { ?s ?p ?o } }", 0, dataset);
    }

    @Test
    public void dynamicAndUnion12() {
        TestDynamicDataset.testCount("SELECT * FROM <urn:x-arq:DefaultGraph>FROM <urn:x-arq:UnionGraph>{ ?s ?p ?o }", 7, dataset);
    }

    @Test
    public void dynamicAndUnion12a() {
        TestDynamicDataset.testCount("SELECT * FROM <urn:x-arq:DefaultGraph>FROM <urn:x-arq:UnionGraph>{ GRAPH ?g { ?s ?p ?o } }", 0, dataset);
    }

    @Test
    public void dynamic99() {
        TestDynamicDataset.testCount("SELECT * FROM NAMED <graph:3> { ?s ?p ?o }", 0, dataset);
    }

    @Test
    public void pattern_01() {
        TestDynamicDataset.testCount("PREFIX : <http://example/> SELECT * FROM :g1 FROM :g2 { ?s :p1 ?x . ?x :p2 ?o }", 2, dataset2);
    }

    @Test
    public void pattern_02() {
        String qs = "PREFIX : <http://example/> SELECT * FROM :g1 FROM :g2 { ?s :p1+ ?x }";
        TestDynamicDataset.testCount(qs, 3, dataset2);
    }

    @Test
    public void pattern_03() {
        String qs = "PREFIX : <http://example/> SELECT * FROM :g1 FROM :g2 { ?s :p1+ ?x }";
        Query query = QueryFactory.create((String)qs);
        DataSource ds = DatasetFactory.create((DatasetGraph)DynamicDatasets.dynamicDataset((Query)query, (DatasetGraph)dataset2.asDatasetGraph(), (boolean)false));
        TestDynamicDataset.testCount(qs, 3, (Dataset)ds);
    }

    private static void testCount(String queryString, int expected, Dataset ds) {
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)ds);
        ResultSet rs = qExec.execSelect();
        int n = ResultSetFormatter.consume((ResultSet)rs);
        TestDynamicDataset.assertEquals((long)expected, (long)n);
    }

    static {
        Logger.getLogger((String)"com.hp.hpl.jena.tdb.info").setLevel(Level.WARN);
        SystemTDB.defaultOptimizer = ReorderLib.identity();
        dataset = TDBFactory.createDataset();
        TestDynamicDataset.init();
        dataStr = StrUtils.strjoinNL((String[])new String[]{"(dataset", "  (graph", "   (triple <http://example/s> <http://example/p> 'dft')", "   (triple <http://example/s> <http://example/p> <http://example/x>)", "   (triple <http://example/x> <http://example/p> <http://example/o>)", " )", " (graph <http://example/g1>", "   (triple <http://example/s> <http://example/p> 'g1')", "   (triple <http://example/s> <http://example/p1> <http://example/x>)", "   (triple <http://example/x> <http://example/p2> <http://example/o>)", " )", " (graph <http://example/g2>", "   (triple <http://example/s> <http://example/p> 'g2')", "   (triple <http://example/x> <http://example/p1> <http://example/z>)", "   (triple <http://example/x> <http://example/p2> <http://example/o>)", "   (triple <http://example/x> <http://example/p2> <http://example/o2>)", " )", " (graph <http://example/g3>", "   (triple <http://example/s> <http://example/p> 'g3')", "   (triple <http://example/s> <http://example/p1> <http://example/y>)", " ))"});
        dataset2 = TDBFactory.createDataset();
        Item item = SSE.parse((String)dataStr);
        DatasetGraph dsg = BuilderGraph.buildDataset((Item)item);
        Iterator iter = dsg.find();
        while (iter.hasNext()) {
            dataset2.asDatasetGraph().add((Quad)iter.next());
        }
        gn1 = SSE.parseNode((String)"<http://example/g1>");
        gn2 = SSE.parseNode((String)"<http://example/g2>");
        gn3 = SSE.parseNode((String)"<http://example/g3>");
        gn9 = SSE.parseNode((String)"<http://example/g9>");
    }
}

