/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.tdb.ConfigTest;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.junit.GraphLocation;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.sys.TDBMaker;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.junit.BaseTest;

public class TestDatasetTDBPersist
extends BaseTest {
    static Node n0 = NodeFactory.parseNode((String)"<http://example/n0>");
    static Node n1 = NodeFactory.parseNode((String)"<http://example/n1>");
    static Node n2 = NodeFactory.parseNode((String)"<http://example/n2>");
    static GraphLocation graphLocation = null;

    @BeforeClass
    public static void beforeClass() {
        graphLocation = new GraphLocation(new Location(ConfigTest.getTestingDirDB()));
    }

    @AfterClass
    public static void afterClass() {
        graphLocation.release();
        graphLocation.clearDirectory();
    }

    @Before
    public void before() {
        graphLocation.clearDirectory();
        graphLocation.createDataset();
    }

    @After
    public void after() {
        graphLocation.release();
        TDBMaker.clearDatasetCache();
    }

    @Test
    public void dataset1() {
        Dataset ds = graphLocation.getDataset();
        TestDatasetTDBPersist.assertTrue((boolean)(ds.asDatasetGraph() instanceof DatasetGraphTDB));
        TestDatasetTDBPersist.assertTrue((boolean)(ds.getDefaultModel().getGraph() instanceof GraphTriplesTDB));
        TestDatasetTDBPersist.assertTrue((boolean)(ds.getNamedModel("http://example/").getGraph() instanceof GraphNamedTDB));
    }

    @Test
    public void dataset2() {
        Dataset ds = graphLocation.getDataset();
        Graph g1 = ds.getDefaultModel().getGraph();
        Graph g2 = ds.getNamedModel("http://example/").getGraph();
        g1.add(new Triple(n0, n1, n2));
        TestDatasetTDBPersist.assertTrue((boolean)g1.contains(n0, n1, n2));
        TestDatasetTDBPersist.assertFalse((boolean)g2.contains(n0, n1, n2));
    }

    @Test
    public void dataset3() {
        Dataset ds = graphLocation.getDataset();
        Graph g1 = ds.getDefaultModel().getGraph();
        g1.getBulkUpdateHandler().removeAll();
        Graph g2 = ds.getNamedModel("http://example/").getGraph();
        g2.add(new Triple(n0, n1, n2));
        TestDatasetTDBPersist.assertTrue((boolean)g2.contains(n0, n1, n2));
        TestDatasetTDBPersist.assertFalse((boolean)g1.contains(n0, n1, n2));
    }

    @Test
    public void dataset4() {
        String graphName = "http://example/";
        Triple triple = SSE.parseTriple((String)"(<x> <y> <z>)");
        Node gn = Node.createURI((String)graphName);
        Dataset ds = graphLocation.getDataset();
        ds.asDatasetGraph().deleteAny(gn, null, null, null);
        Graph g2 = ds.asDatasetGraph().getGraph(gn);
        TestDatasetTDBPersist.assertFalse((boolean)ds.containsNamedModel(graphName));
        Iterator iter = ds.listNames();
        TestDatasetTDBPersist.assertFalse((boolean)iter.hasNext());
        TestDatasetTDBPersist.assertEquals((long)0L, (long)ds.asDatasetGraph().size());
    }

    @Test
    public void dataset5() {
        String graphName = "http://example/";
        Triple triple = SSE.parseTriple((String)"(<x> <y> <z>)");
        Dataset ds = graphLocation.getDataset();
        Graph g2 = ds.asDatasetGraph().getGraph(Node.createURI((String)graphName));
        g2.add(triple);
        TestDatasetTDBPersist.assertTrue((boolean)ds.containsNamedModel(graphName));
        Iterator iter = ds.listNames();
        List x = Iter.toList((Iterator)iter);
        List<String> y = Arrays.asList(graphName);
        TestDatasetTDBPersist.assertEquals((Object)x, y);
        TestDatasetTDBPersist.assertEquals((long)1L, (long)ds.asDatasetGraph().size());
    }
}

