/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import com.hp.hpl.jena.tdb.TDBFactory;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.StrUtils;

public class TestConcurrentAccess
extends BaseTest {
    static String data = StrUtils.strjoinNL((String[])new String[]{"(graph", "  (<x> <p> 1)", "  (<x> <p> 2)", "  (<x> <p> 3)", "  (<x> <p> 4)", "  (<x> <p> 5)", "  (<x> <p> 6)", "  (<x> <p> 7)", "  (<x> <p> 8)", "  (<x> <p> 9)", ")"});

    private static Graph buildGraph() {
        Item item = SSE.parse((String)data);
        Graph g = BuilderGraph.buildGraph((Item)item);
        return g;
    }

    private static Dataset create() {
        Graph g = TestConcurrentAccess.buildGraph();
        Dataset ds = TDBFactory.createDataset();
        ds.getDefaultModel().getGraph().getBulkUpdateHandler().add(g);
        return ds;
    }

    @Test
    public void mrswGraph1() {
        Model m = TestConcurrentAccess.create().getDefaultModel();
        Resource r = m.createResource("x");
        StmtIterator iter1 = m.listStatements(r, null, (RDFNode)null);
        TestConcurrentAccess.assertNotNull((Object)iter1.next());
        StmtIterator iter2 = m.listStatements(r, null, (RDFNode)null);
        TestConcurrentAccess.assertNotNull((Object)iter2.next());
        while (iter2.hasNext()) {
            iter2.next();
        }
        TestConcurrentAccess.assertNotNull((Object)iter1.next());
    }

    @Test(expected=ConcurrentModificationException.class)
    public void mrswGraph2() {
        Model m = TestConcurrentAccess.create().getDefaultModel();
        Resource r = m.createResource("x");
        StmtIterator iter1 = m.listStatements(r, null, (RDFNode)null);
        TestConcurrentAccess.assertNotNull((Object)iter1.next());
        Triple t = SSE.parseTriple((String)"(<y> <p> 99)");
        m.getGraph().add(t);
        iter1.hasNext();
    }

    @Test(expected=ConcurrentModificationException.class)
    public void mrswGraph3() {
        Model m = TestConcurrentAccess.create().getDefaultModel();
        Resource r = m.createResource("x");
        StmtIterator iter1 = m.listStatements(r, null, (RDFNode)null);
        TestConcurrentAccess.assertNotNull((Object)iter1.next());
        Triple t = SSE.parseTriple((String)"(<y> <p> 99)");
        m.getGraph().delete(t);
        iter1.hasNext();
    }

    @Test(expected=ConcurrentModificationException.class)
    public void mrswGraph4() {
        Model m = TestConcurrentAccess.create().getDefaultModel();
        Resource r = m.createResource("x");
        StmtIterator iter1 = m.listLiteralStatements(r, null, 1L);
        TestConcurrentAccess.assertNotNull((Object)iter1.next());
        Triple t = SSE.parseTriple((String)"(<y> <p> 99)");
        m.getGraph().add(t);
        iter1.hasNext();
    }

    @Test
    public void mrswGraph5() {
        Dataset d = TDBFactory.createDataset();
        Model m = d.getNamedModel("http://example");
        m.getGraph().getBulkUpdateHandler().add(TestConcurrentAccess.buildGraph());
        Resource r = m.createResource("x");
        StmtIterator iter1 = m.listStatements(r, null, (RDFNode)null);
        while (iter1.hasNext()) {
            iter1.next();
        }
        Triple t = SSE.parseTriple((String)"(<y> <p> 99)");
        m.getGraph().delete(t);
        iter1.hasNext();
    }

    @Test(expected=ConcurrentModificationException.class)
    public void mrswGraph6() {
        Dataset d = TDBFactory.createDataset();
        Model m = d.getNamedModel("http://example");
        m.getGraph().getBulkUpdateHandler().add(TestConcurrentAccess.buildGraph());
        Resource r = m.createResource("x");
        StmtIterator iter1 = m.listStatements(r, null, (RDFNode)null);
        TestConcurrentAccess.assertNotNull((Object)iter1.next());
        Triple t = SSE.parseTriple((String)"(<y> <p> 99)");
        m.getGraph().delete(t);
        iter1.next();
    }

    @Test
    public void mrswSPARQL1() {
        Dataset ds = TestConcurrentAccess.create();
        Query query = QueryFactory.create((String)"SELECT * { ?s ?p ?o}");
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)ds);
        ResultSet rs = qExec.execSelect();
        while (rs.hasNext()) {
            rs.next();
        }
        qExec.close();
        DatasetGraph dsg = ds.asDatasetGraph();
        Quad quad = SSE.parseQuad((String)"(<g> <y> <p> 99)");
        dsg.add(quad);
        Iterator iter = dsg.find();
        iter.hasNext();
        iter.next();
    }

    @Test(expected=ConcurrentModificationException.class)
    public void mrswSPARQL2() {
        Dataset ds = TestConcurrentAccess.create();
        DatasetGraph dsg = ds.asDatasetGraph();
        Query query = QueryFactory.create((String)"SELECT * { ?s ?p ?o}");
        QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)ds);
        ResultSet rs = qExec.execSelect();
        rs.hasNext();
        rs.next();
        Quad quad = SSE.parseQuad((String)"(<g> <y> <p> 99)");
        dsg.add(quad);
        rs.hasNext();
        rs.next();
    }

    @Test(expected=ConcurrentModificationException.class)
    public void mrswDataset1() {
        DatasetGraph dsg = TestConcurrentAccess.create().asDatasetGraph();
        Quad quad = SSE.parseQuad((String)"(<g> <y> <p> 99)");
        Iterator iter = dsg.find();
        dsg.add(quad);
        iter.hasNext();
        iter.next();
    }
}

