/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public abstract class TestNodeTableBase
extends BaseTest {
    protected static final Node n1 = NodeFactory.parseNode((String)"<http://example/x>");
    protected static final Node n2 = NodeFactory.parseNode((String)"1");

    protected abstract NodeTable createEmptyNodeTable();

    protected void testNode(String str) {
        this.testNode(NodeFactory.parseNode((String)str));
    }

    protected void testNode(Node n) {
        NodeTable nt = this.createEmptyNodeTable();
        NodeId nodeId = nt.getAllocateNodeId(n);
        TestNodeTableBase.assertNotNull((Object)nodeId);
        TestNodeTableBase.assertNotEquals((Object)NodeId.NodeDoesNotExist, (Object)nodeId);
        TestNodeTableBase.assertNotEquals((Object)NodeId.NodeIdAny, (Object)nodeId);
        Node n2 = nt.getNodeForNodeId(nodeId);
        TestNodeTableBase.assertEquals((Object)n, (Object)n2);
        NodeId nodeId2 = nt.getNodeIdForNode(n);
        TestNodeTableBase.assertEquals((Object)nodeId, (Object)nodeId2);
    }

    @Test
    public void nodetable_01() {
        this.testNode("<http://example/x>");
    }

    @Test
    public void nodetable_02() {
        this.testNode("1");
    }

    @Test
    public void nodetable_03() {
        this.testNode("_:x");
    }

    @Test
    public void nodetable_04() {
        this.testNode("'x'");
    }

    @Test
    public void nodetable_05() {
        this.testNode("'x'@en");
    }

    @Test
    public void nodetable_06() {
        this.testNode("'x'^^<http://example/dt>");
    }
}

