/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.tdb.nodetable.Nodec;
import com.hp.hpl.jena.tdb.nodetable.NodecSSE;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.ByteBufferLib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class TestCodec
extends BaseTest {
    private static final String asciiBase = "abc";
    private static final String latinBase = "\u00c0\u00e9\u00ed\u00ff";
    private static final String latinExtraBase = "\u1ef9\ufb01\ufb02";
    private static final String greekBase = "\u03b1\u03b2\u03b3";
    private static final String hewbrewBase = "\u05d0\u05d1\u05d2";
    private static final String arabicBase = "\u0621\u0622\u0623";
    private static final String symbolsBase = "\u263a\u263b\u266a\u266b";
    private static final String chineseBase = "\u5b6b\u5b50\u5175\u6cd5";
    private static final String japaneseBase = "\u65e5\u672c";
    private Nodec nodec;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{new NodecSSE()}});
    }

    public TestCodec(Nodec nodec) {
        this.nodec = nodec;
    }

    @Test
    public void nodec_lit_01() {
        this.test("''");
    }

    @Test
    public void nodec_lit_02() {
        this.test("'a'");
    }

    @Test
    public void nodec_lit_03() {
        this.test("'ab'");
    }

    @Test
    public void nodec_lit_04() {
        this.test("'abc'");
    }

    @Test
    public void nodec_lit_05() {
        this.test("'abcd'");
    }

    @Test
    public void nodec_lit_06() {
        this.test("''@e");
    }

    @Test
    public void nodec_lit_07() {
        this.test("''@en");
    }

    @Test
    public void nodec_lit_08() {
        this.test("''@EN-uk");
    }

    @Test
    public void nodec_lit_09() {
        this.test("'\\n'@EN-uk");
    }

    @Test
    public void nodec_lit_10() {
        this.test("'\u00c0\u00e9\u00ed\u00ff'");
    }

    @Test
    public void nodec_lit_11() {
        this.test("'\u1ef9\ufb01\ufb02'");
    }

    @Test
    public void nodec_lit_12() {
        this.test("'\u03b1\u03b2\u03b3'");
    }

    @Test
    public void nodec_lit_13() {
        this.test("'\u05d0\u05d1\u05d2'");
    }

    @Test
    public void nodec_lit_14() {
        this.test("'\u0621\u0622\u0623'");
    }

    @Test
    public void nodec_lit_15() {
        this.test("'\u263a\u263b\u266a\u266b'");
    }

    @Test
    public void nodec_lit_16() {
        this.test("'\u5b6b\u5b50\u5175\u6cd5'");
    }

    @Test
    public void nodec_lit_17() {
        this.test("'\u65e5\u672c'");
    }

    @Test
    public void nodec_lit_20() {
        this.test("1");
    }

    @Test
    public void nodec_lit_21() {
        this.test("12.3");
    }

    @Test
    public void nodec_lit_22() {
        this.test("''^^<>");
    }

    @Test
    public void nodec_uri_01() {
        this.test("<>");
    }

    @Test
    public void nodec_uri_02() {
        this.test("<http://example/>");
    }

    @Test
    public void nodec_blank_01() {
        this.test(Node.createAnon((AnonId)new AnonId("a")));
    }

    @Test
    public void nodec_blank_02() {
        this.test(Node.createAnon((AnonId)new AnonId("a:b:c-d")));
    }

    @Test
    public void nodec_blank_03() {
        this.test(Node.createAnon());
    }

    private void test(String sseString) {
        Node n = NodeFactory.parseNode((String)sseString);
        this.test(n);
    }

    private void test(Node n) {
        int maxSize = this.nodec.maxSize(n);
        ByteBuffer bb = ByteBuffer.allocate(maxSize);
        int x = this.nodec.encode(n, bb, null);
        int bbLen = bb.limit() - bb.position();
        TestCodec.assertEquals((long)bbLen, (long)x);
        TestCodec.assertEquals((long)0L, (long)bb.position());
        ByteBuffer bb2 = ByteBufferLib.duplicate((ByteBuffer)bb);
        Node n2 = this.nodec.decode(bb2, null);
        TestCodec.assertEquals((Object)n, (Object)n2);
    }
}

