/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.migrate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import com.hp.hpl.jena.tdb.migrate.GraphUnionRead;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGraphUnionRead
extends BaseTest {
    private static String dataStr = StrUtils.strjoinNL((String[])new String[]{"(dataset", "  (graph", "   (triple <http://example/s> <http://example/p> 'dft')", "   (triple <http://example/s> <http://example/p> <http://example/o>)", " )", " (graph <http://example/g1>", "   (triple <http://example/s> <http://example/p> 'g1')", "   (triple <http://example/s> <http://example/p> <http://example/o>)", " )", " (graph <http://example/g2>", "   (triple <http://example/s> <http://example/p> 'g2')", "   (triple <http://example/s> <http://example/p> <http://example/o>)", " )", " (graph <http://example/g3>", "   (triple <http://example/s> <http://example/p> 'g3')", "   (triple <http://example/s> <http://example/p> <http://example/o>)", " ))"});
    private static DatasetGraph dsg = null;
    private static Node gn1;
    private static Node gn2;
    private static Node gn3;
    private static Node gn9;

    @Test
    public void gr_union_01() {
        List<Node> gnodes = TestGraphUnionRead.list(gn1, gn2);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x = Iter.count((Iterator)g.find(null, null, null));
        TestGraphUnionRead.assertEquals((long)3L, (long)x);
    }

    @Test
    public void gr_union_02() {
        List<Node> gnodes = TestGraphUnionRead.list(gn1, gn2);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        Node s = Node.createURI((String)"http://example/s");
        long x = Iter.count((Iterator)g.find(s, null, null));
        TestGraphUnionRead.assertEquals((long)3L, (long)x);
    }

    @Test
    public void gr_union_03() {
        List<Node> gnodes = TestGraphUnionRead.list(gn1, gn2, gn9);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        Node o = Node.createLiteral((String)"g2");
        long x = Iter.count((Iterator)g.find(null, null, o));
        TestGraphUnionRead.assertEquals((long)1L, (long)x);
    }

    @Test
    public void gr_union_04() {
        List<Node> gnodes = TestGraphUnionRead.list(gn9);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x = Iter.count((Iterator)g.find(null, null, null));
        TestGraphUnionRead.assertEquals((long)0L, (long)x);
    }

    @Test
    public void gr_union_05() {
        List<Object> gnodes = TestGraphUnionRead.list(new Object[0]);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x = Iter.count((Iterator)g.find(null, null, null));
        TestGraphUnionRead.assertEquals((long)0L, (long)x);
    }

    @Test
    public void gr_union_06() {
        List<Node> gnodes = TestGraphUnionRead.list(gn1, gn1);
        GraphUnionRead g = new GraphUnionRead(dsg, gnodes);
        long x = Iter.count((Iterator)g.find(null, null, null));
        TestGraphUnionRead.assertEquals((long)2L, (long)x);
    }

    static <T> List<T> list(T ... x) {
        return Arrays.asList(x);
    }

    static {
        Item item = SSE.parse((String)dataStr);
        dsg = BuilderGraph.buildDataset((Item)item);
        gn1 = SSE.parseNode((String)"<http://example/g1>");
        gn2 = SSE.parseNode((String)"<http://example/g2>");
        gn3 = SSE.parseNode((String)"<http://example/g3>");
        gn9 = SSE.parseNode((String)"<http://example/g9>");
    }
}

