/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.lib;

import com.hp.hpl.jena.tdb.lib.StringAbbrev;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public class TestStringAbbrev
extends BaseTest {
    @Test
    public void abbrev_01() {
        StringAbbrev abbrev = new StringAbbrev();
        this.test("Hello", "Hello", abbrev);
    }

    @Test
    public void abbrev_02() {
        StringAbbrev abbrev = new StringAbbrev();
        this.test(":Hello", ":_:Hello", abbrev);
    }

    @Test
    public void abbrev_03() {
        StringAbbrev abbrev = new StringAbbrev();
        this.test("::Hello", ":_::Hello", abbrev);
    }

    @Test
    public void abbrev_04() {
        StringAbbrev abbrev = new StringAbbrev();
        abbrev.add("x", "He");
        this.test("Hello", ":x:llo", abbrev);
        this.test("hello", "hello", abbrev);
        this.test(":hello", ":_:hello", abbrev);
    }

    private void test(String x, String y, StringAbbrev abbrev) {
        String z1 = abbrev.abbreviate(x);
        TestStringAbbrev.assertEquals((Object)y, (Object)z1);
        String z2 = abbrev.expand(z1);
        TestStringAbbrev.assertEquals((Object)x, (Object)z2);
    }
}

