/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.junit;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryExecutionBase;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineRef;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.EarlTestCase;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.resultset.ResultSetCompare;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.junit.TDBTestException;
import com.hp.hpl.jena.tdb.sys.DatasetGraphMakerTDB;
import com.hp.hpl.jena.util.FileManager;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTestTDB
extends EarlTestCase {
    private static Logger log = LoggerFactory.getLogger(QueryTestTDB.class);
    private Dataset dataset = null;
    boolean skipThisTest = false;
    final List<String> defaultGraphURIs;
    final List<String> namedGraphURIs;
    final String queryFile;
    final SPARQLResult results;
    private final DatasetGraphMakerTDB factory;
    private static List<String> currentDefaultGraphs = null;
    private static List<String> currentNamedGraphs = null;

    public QueryTestTDB(String testName, EarlReport report, TestItem item, DatasetGraphMakerTDB factory) {
        this(testName, report, item.getURI(), item.getDefaultGraphURIs(), item.getNamedGraphURIs(), item.getResults(), item.getQueryFile(), factory);
    }

    public QueryTestTDB(String testName, EarlReport report, String uri, List<String> dftGraphs, List<String> namedGraphs, SPARQLResult rs, String queryFile, DatasetGraphMakerTDB factory) {
        super(testName, uri, report);
        this.defaultGraphURIs = dftGraphs;
        this.namedGraphURIs = namedGraphs;
        this.queryFile = queryFile;
        this.results = rs;
        this.factory = factory;
    }

    public void setUp() {
        this.dataset = TDBFactory.createDataset();
        this.setupData();
    }

    public void tearDown() {
        if (this.dataset != null) {
            this.dataset.close();
        }
    }

    public void setupData() {
        if (QueryTestTDB.compareLists(this.defaultGraphURIs, currentDefaultGraphs) && QueryTestTDB.compareLists(this.namedGraphURIs, currentNamedGraphs)) {
            return;
        }
        if (this.defaultGraphURIs == null) {
            throw new TDBTestException("No default graphs given");
        }
        for (String fn : this.defaultGraphURIs) {
            QueryTestTDB.load(this.dataset.getDefaultModel(), fn);
        }
        for (String fn : this.namedGraphURIs) {
            QueryTestTDB.load(this.dataset.getNamedModel(fn), fn);
        }
    }

    protected void runTestForReal() throws Throwable {
        if (this.skipThisTest) {
            log.info(this.getName() + " : Skipped");
            return;
        }
        Query query = QueryFactory.read((String)this.queryFile);
        Object oldValue = ARQ.getContext().get(ARQ.strictGraph);
        ARQ.setTrue((Symbol)ARQ.strictGraph);
        Dataset ds = DatasetFactory.create(this.defaultGraphURIs, this.namedGraphURIs);
        ARQ.getContext().set(ARQ.strictGraph, oldValue);
        ResultSetRewindable rs1 = null;
        String expectedLabel = "";
        if (this.results != null) {
            rs1 = ResultSetFactory.makeRewindable((ResultSet)this.results.getResultSet());
            expectedLabel = "Results file";
        } else {
            QueryEngineFactory f = QueryEngineRef.getFactory();
            QueryExecutionBase qExec1 = new QueryExecutionBase(query, ds, null, f);
            rs1 = ResultSetFactory.makeRewindable((ResultSet)qExec1.execSelect());
            qExec1.close();
            expectedLabel = "Standard engine";
        }
        Dataset ds2 = this.dataset;
        QueryExecution qExec2 = QueryExecutionFactory.create((Query)query, (Dataset)ds2);
        ResultSet rs = qExec2.execSelect();
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)rs);
        boolean b = ResultSetCompare.equalsByValue((ResultSet)rs1, (ResultSet)rs2);
        if (!b) {
            rs1.reset();
            rs2.reset();
            System.out.println("------------------- " + this.getName());
            System.out.printf("**** Expected (%s)", expectedLabel);
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs1);
            System.out.println("**** Got (TDB)");
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs2);
        }
        QueryTestTDB.assertTrue((String)"Results sets not the same", (boolean)b);
    }

    private static void load(Model model, String fn) {
        FileManager.get().readModel(model, fn);
    }

    private static boolean compareLists(List<String> list1, List<String> list2) {
        if (list1 == null) {
            return list2 == null;
        }
        return ((Object)list1).equals(list2);
    }
}

