/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.ext;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.ext.ExtHash;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.ListUtils;
import org.openjena.atlas.lib.RandomLib;
import org.openjena.atlas.test.ExecGenerator;
import org.openjena.atlas.test.Gen;
import org.openjena.atlas.test.RepeatExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtHashTestBase {
    public static final RecordFactory factory = new RecordFactory(4, 4);

    public static void randTests(int maxValue, int maxNumKeys, int iterations, boolean showProgess) {
        ExtHashTest test = new ExtHashTest(maxValue, maxNumKeys);
        RepeatExecution.repeatExecutions((ExecGenerator)test, (int)iterations, (boolean)showProgess);
    }

    public static void randTest(int maxValue, int numKeys) {
        int[] r1 = Gen.rand((int)numKeys, (int)0, (int)maxValue);
        int[] r2 = Gen.permute((int[])r1, (int)(4 * numKeys));
        ExtHashTestBase.runTest(r1, r2);
    }

    public static void runTest(int[] r1, int[] r2) {
        try {
            ExtHash extHash = ExtHashTestBase.create(r1);
            ExtHashTestBase.check(extHash, r1);
            ExtHashTestBase.delete(extHash, r2);
            ExtHashTestBase.check(extHash, new int[0]);
        }
        catch (RuntimeException ex) {
            System.err.println();
            System.err.printf("int[] r1 = {%s} ;\n", Gen.strings((int[])r1));
            System.err.printf("int[] r2 = {%s}; \n", Gen.strings((int[])r2));
            throw ex;
        }
    }

    public static ExtHash make() {
        return ExtHash.createMem((RecordFactory)factory, (int)128);
    }

    public static Record intToRecord(int v) {
        byte[] key = Bytes.packInt((int)v);
        byte[] val = Bytes.packInt((int)(v + 100));
        return factory.create(key, val);
    }

    public static Record intToRecordKey(int v) {
        byte[] key = Bytes.packInt((int)v);
        return factory.create(key);
    }

    public static ExtHash create(int ... recs) {
        ExtHash extHash = ExtHashTestBase.make();
        for (int i : recs) {
            Record r = ExtHashTestBase.intToRecord(i);
            extHash.add(r);
        }
        return extHash;
    }

    public static ExtHash delete(ExtHash extHash, int ... recs) {
        for (int i : recs) {
            Record r = ExtHashTestBase.intToRecord(i);
            extHash.delete(r);
        }
        return extHash;
    }

    public static void check(ExtHash extHash, int ... recs) {
        extHash.check();
        for (int i : recs) {
            Record r = ExtHashTestBase.intToRecordKey(i);
            Assert.assertNotNull((Object)extHash.find(r));
        }
        List y = ListUtils.unique((List)ListUtils.asList((int[])recs));
        int x = (int)extHash.size();
        if (x < 0) {
            x = (int)extHash.sessionTripleCount();
        }
        Assert.assertEquals((long)y.size(), (long)x);
    }

    public static void check(Iterator<Integer> iter, int ... recs) {
        for (int i : recs) {
            Assert.assertTrue((String)"Iterator shorter than test answers", (boolean)iter.hasNext());
            int j = iter.next();
            Assert.assertEquals((long)i, (long)j);
        }
        Assert.assertFalse((String)"Iterator longer than test answers", (boolean)iter.hasNext());
    }

    static class ExtHashTest
    implements ExecGenerator {
        int maxNumKeys;
        int maxValue;

        ExtHashTest(int maxValue, int maxNumKeys) {
            if (maxValue <= maxNumKeys) {
                throw new IllegalArgumentException("ExtHashTest: Max value less than number of keys");
            }
            this.maxValue = maxValue;
            this.maxNumKeys = maxNumKeys;
        }

        public void executeOneTest() {
            int numKeys = RandomLib.random.nextInt(this.maxNumKeys) + 1;
            ExtHashTestBase.randTest(this.maxValue, numKeys);
        }
    }
}

