/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeException;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeRewriter;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeRewriterUtils;
import com.hp.hpl.jena.tdb.sys.SetupTDB;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Bytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBPlusTreeRewriter
extends BaseTest {
    static int KeySize = 4;
    static int ValueSize = 8;
    static RecordFactory recordFactory = new RecordFactory(KeySize, ValueSize);

    @Test
    public void bpt_rewrite_01() {
        TestBPlusTreeRewriter.runTest(2, 0);
    }

    @Test
    public void bpt_rewrite_02() {
        TestBPlusTreeRewriter.runTest(3, 0);
    }

    @Test
    public void bpt_rewrite_03() {
        TestBPlusTreeRewriter.runTest(2, 1);
    }

    @Test
    public void bpt_rewrite_04() {
        TestBPlusTreeRewriter.runTest(3, 1);
    }

    @Test
    public void bpt_rewrite_05() {
        TestBPlusTreeRewriter.runTest(2, 2);
    }

    @Test
    public void bpt_rewrite_06() {
        TestBPlusTreeRewriter.runTest(3, 2);
    }

    @Test
    public void bpt_rewrite_07() {
        TestBPlusTreeRewriter.runTest(2, 100);
    }

    @Test
    public void bpt_rewrite_08() {
        TestBPlusTreeRewriter.runTest(3, 100);
    }

    @Test
    public void bpt_rewrite_99() {
        TestBPlusTreeRewriter.runTest(5, 1000);
    }

    static void runTest(int order, int N) {
        TestBPlusTreeRewriter.runOneTest(order, N, recordFactory, false);
    }

    static void runOneTest(int order, int N, RecordFactory recordFactory, boolean debug) {
        BPlusTreeParams bptParams = new BPlusTreeParams(order, recordFactory);
        BPlusTreeRewriter.debug = debug;
        List<Record> originaldata = TestBPlusTreeRewriter.createData(N, recordFactory);
        FileSet destination = FileSet.mem();
        BlockMgr blkMgr1 = BlockMgrFactory.create((FileSet)destination, (String)"idn", (int)bptParams.getBlockSize(), (int)10, (int)10);
        BlockMgr blkMgr2 = BlockMgrFactory.create((FileSet)destination, (String)"idn", (int)bptParams.getBlockSize(), (int)10, (int)10);
        BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree(originaldata.iterator(), (BPlusTreeParams)bptParams, (RecordFactory)recordFactory, (BlockMgr)blkMgr1, (BlockMgr)blkMgr2);
        if (debug) {
            BPlusTreeRewriterUtils.divider();
            bpt2.dump();
        }
        bpt2.check();
        TestBPlusTreeRewriter.scanComparision(originaldata, bpt2);
        TestBPlusTreeRewriter.findComparison(originaldata, bpt2);
        TestBPlusTreeRewriter.sizeComparison(originaldata, bpt2);
    }

    public static void scanComparision(List<Record> originaldata, BPlusTree bpt2) {
        Iterator<Record> iter1 = originaldata.iterator();
        Iterator iter2 = bpt2.iterator();
        long count = 0L;
        while (iter1.hasNext()) {
            Record r2;
            ++count;
            Record r1 = iter1.next();
            if (!iter2.hasNext()) {
                TestBPlusTreeRewriter.error("Deviation: new B+Tree is smaller", new Object[0]);
            }
            if (Record.equals((Record)r1, (Record)(r2 = (Record)iter2.next()))) continue;
            TestBPlusTreeRewriter.error("Deviation in iteration record %d: %s : %s", count, r1, r2);
        }
        if (iter2.hasNext()) {
            TestBPlusTreeRewriter.error("New B+Tree larger than original", new Object[0]);
        }
    }

    public static void findComparison(List<Record> originaldata, BPlusTree bpt2) {
        Iterator<Record> iter1 = originaldata.iterator();
        long count = 0L;
        while (iter1.hasNext()) {
            ++count;
            Record r1 = iter1.next();
            Record r3 = bpt2.find(r1);
            if (r3 == null) {
                r3 = bpt2.find(r1);
                TestBPlusTreeRewriter.error("Deviation in find at record %d: %s : null", count, r1);
            }
            if (Record.equals((Record)r1, (Record)r3)) continue;
            TestBPlusTreeRewriter.error("Deviation in find at record %d: %s : %s", count, r1, r3);
        }
    }

    public static void sizeComparison(List<Record> originaldata, BPlusTree bpt2) {
        long count2;
        long count1 = originaldata.size();
        if (count1 != (count2 = bpt2.size())) {
            System.err.println("**** DIFFERENT");
        }
    }

    static List<Record> createData(int N, RecordFactory recordFactory) {
        ArrayList<Record> originaldata = new ArrayList<Record>(N);
        for (int i = 0; i < N; ++i) {
            Record record = recordFactory.create();
            Bytes.setInt((int)(i + 1), (byte[])record.getKey());
            if (recordFactory.hasValue()) {
                Bytes.setInt((int)(10 * i + 1), (byte[])record.getValue());
            }
            originaldata.add(record);
        }
        return originaldata;
    }

    static List<Record> createData2(int ORDER, int N, RecordFactory recordFactory) {
        BPlusTree bpt = (BPlusTree)SetupTDB.createBPTree((FileSet)FileSet.mem(), (int)ORDER, (int)-1, (int)-1, (int)-1, (RecordFactory)recordFactory);
        for (int i = 0; i < N; ++i) {
            Record record = recordFactory.create();
            Bytes.setInt((int)(i + 1), (byte[])record.getKey());
            bpt.add(record);
        }
        return Iter.toList((Iterator)bpt.iterator());
    }

    private static void error(String string, Object ... args) {
        String msg = String.format(string, args);
        System.err.println(msg);
        throw new BPTreeException(msg);
    }
}

