/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrWrapper;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.bplustree.TestBPlusTreeRewriter;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.openjena.atlas.lib.ByteBufferLib;
import org.openjena.atlas.lib.RandomLib;
import org.openjena.atlas.logging.Log;

public class CmdTestBPlusTreeRewriter {
    public static void main(String ... argv) {
        if (argv.length != 3) {
            System.err.println("Usage: " + Utils.classShortName(CmdTestBPlusTreeRewriter.class) + " maxOrder maxSize NumTests");
            System.exit(1);
        }
        SystemTDB.NullOut = true;
        boolean debug = false;
        int MaxOrder = -1;
        int MinOrder = 2;
        int MinSize = 0;
        int MaxSize = -1;
        int NumTest = -1;
        try {
            MaxOrder = Integer.parseInt(argv[0]);
        }
        catch (NumberFormatException ex) {
            System.err.println("Bad number for MaxOrder");
            System.exit(1);
        }
        try {
            MaxSize = Integer.parseInt(argv[1]);
        }
        catch (NumberFormatException ex) {
            System.err.println("Bad number for MaxSize");
            System.exit(1);
        }
        try {
            NumTest = Integer.parseInt(argv[2]);
        }
        catch (NumberFormatException ex) {
            System.err.println("Bad number for NumTest");
            System.exit(1);
        }
        int KeySize = 4;
        int ValueSize = 8;
        RecordFactory recordFactory = new RecordFactory(KeySize, ValueSize);
        int successes = 0;
        int failures = 0;
        int[] orders = null;
        int[] sizes = null;
        orders = new int[NumTest];
        sizes = new int[NumTest];
        for (int i = 0; i < orders.length; ++i) {
            int order = MinOrder == MaxOrder ? MinOrder : MinOrder + RandomLib.random.nextInt(MaxOrder - MinOrder);
            int size = MinSize == MaxSize ? MinSize : MinSize + RandomLib.random.nextInt(MaxSize - MinSize);
            orders[i] = order;
            sizes[i] = size;
        }
        int numOnLine = 50;
        int testsPerTick = 500;
        int testCount = 1;
        for (testCount = 1; testCount <= orders.length; ++testCount) {
            if (testCount % testsPerTick == 0) {
                System.out.print(".");
            }
            if (testCount % (testsPerTick * numOnLine) == 0) {
                System.out.println();
            }
            int idx = testCount - 1;
            int order = orders[idx];
            int size = sizes[idx];
            try {
                TestBPlusTreeRewriter.runOneTest(order, size, recordFactory, debug);
                ++successes;
                continue;
            }
            catch (RuntimeException ex) {
                System.err.printf("-- Fail: (order=%d, size=%d)\n", order, size);
                ex.printStackTrace(System.err);
                System.err.printf("--------------------------\n", new Object[0]);
                ++failures;
            }
        }
        if (testCount % (testsPerTick * numOnLine) != 0) {
            System.out.println();
        }
        System.err.flush();
        System.out.flush();
        System.out.printf("DONE : %,d tests : Success=%,d, Failures=%,d\n", NumTest, successes, failures);
    }

    static {
        Log.setLog4j();
    }

    static class BlockMgrWriteLogger
    extends BlockMgrWrapper {
        public BlockMgrWriteLogger(BlockMgr blockMgr) {
            super(blockMgr);
        }

        public void put(int id, ByteBuffer block) {
            System.err.println("Write block " + id);
            ByteBufferLib.print((PrintStream)System.err, (ByteBuffer)block);
            if (block.getInt(0) == 0) {
                System.err.println("  Type zero");
            }
            super.put(id, block);
        }
    }
}

